/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.EnumSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.14")
@CheckID(value="SVTB.4.1.4.1.2")
@CheckName(value="SVTB.4.1.4.1.2")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.DIRECTIVE, RuleLabel.DELAY, RuleLabel.TIMESCALE})
@CheckTitle(value="Specify time units for all delays")
@CheckDescription(value="Do not rely on the `timescale to define the delay's time unit.\n\nExamples:\n#1step // allowed\n#0 // allowed \n#(delay_value * 1ps) // allowed\n#variable // allowed iff allowVariableUsages is true\n#5 // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_4_1_4_1_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, using variables for delays is allowed.", name="allowVariableUsages", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowVariableUsages;
    private static final EnumSet<HidFlatteningOption> HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_METHOD_CALLS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS);
    HidOperatorVisitor localHidOperatorVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator operator) {
            if (!(operator instanceof RfHidOperator)) {
                return true;
            }
            if (Check_SVTB_4_1_4_1_2.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            RfHidOperator hidOperator = (RfHidOperator)operator;
            if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_DELAY_CONTROL)) {
                return true;
            }
            Check_SVTB_4_1_4_1_2.this.notifyCheckAlive();
            Set hids = hidOperator.getLHHids(HID_FLATTENING);
            for (IHid hid : hids) {
                if (hid instanceof RfHidImplicit && Check_SVTB_4_1_4_1_2.this.isTimeValue(((RfHidImplicit)hid).getName())) {
                    return true;
                }
                if (!Check_SVTB_4_1_4_1_2.this.pAllowVariableUsages || !(hid instanceof RfHid) || !(((RfHid)hid).getElement() instanceof RfField)) continue;
                return true;
            }
            Check_SVTB_4_1_4_1_2.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "Delay value must have specified time unit!");
            return true;
        }
    };

    public Check_SVTB_4_1_4_1_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.localHidOperatorVisitor);
    }

    protected boolean isTimeValue(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("0|1step") || LintUtils.isTimeValue(str);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

