/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.EnumSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="19.1.23")
@CheckID(value="SVTB.4.1.4.1.3")
@CheckName(value="SVTB.4.1.4.1.3")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.DIRECTIVE, RuleLabel.DELAY})
@CheckTitle(value="Do not specify time units for delays")
@CheckDescription(value="Do not specify time units for delays.\n\nExamples:\ninput_name = #21ms 3; // not allowed\ninput_name = #131 3; // allowed\n")
public class Check_SVTB_4_1_4_1_3
extends OVMComplianceCheck {
    private static final EnumSet<HidFlatteningOption> HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALLS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS);

    public Check_SVTB_4_1_4_1_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidOperator>(){
            ParserPath parserPath;

            public boolean visit(IHidOperator hidOperator) {
                if (!(hidOperator instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator operator = (RfHidOperator)hidOperator;
                if (!operator.hasOccurrence(HidOperatorQualifier.IS_DELAY_CONTROL)) {
                    return true;
                }
                Check_SVTB_4_1_4_1_3.this.notifyCheckAlive();
                Set hids = hidOperator.getLHHids(HID_FLATTENING);
                for (IHid hid : hids) {
                    if (!(hid instanceof RfHidImplicit) || !LintUtils.isTimeValue(((RfHidImplicit)hid).getName())) continue;
                    Check_SVTB_4_1_4_1_3.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "Delay with time unit " + HidUtils.toNiceString((IHidObject)hidOperator) + " is used!");
                    return true;
                }
                return true;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<IHidOperator> getType() {
                return IHidOperator.class;
            }
        });
    }
}

