/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.text.MessageFormat;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.4.1.6.1")
@CheckName(value="SVTB.4.1.6.1")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.ARRAY, RuleLabel.ASSIGNMENT, RuleLabel.CONCATENATION})
@CheckTitle(value="Do not assign array from concatenation")
@CheckDescription(value="Use array assignment patterns instead of concatenation for assigning arrays, dynamic arrays, associative arrays or queues.\nConcatenation braces {...} are used to construct and deconstruct simple bit vectors.\nArray assignment patterns '{...} are used to support the construction of arrays.\n\nExamples:\nint arr1[], arr2[];\nint arr3[][];\nint q1[$], q2[$];\narr1 = {1, 2, 3};\t// not allowed\narr2 = '{4, 5, 6}; // allowed\narr1 = {arr2[0], arr2[1]}; // not allowed\narr3 ='{'{1,2}, '{3,4}}; // allowed\narr3 = '{{1,2}, {3,4}}; // not allowed\narr3[0] = '{3,4,5}; // allowed\narr3[0] = {3,4,5}; // not allowed\nq1 = {7,8,9}; // not allowed\nq1 = '{7,8,9}; // allowed\nq2 = {q1[0:$-2], 10, q1[$-1]}; // not allowed\n\nImplementation Notes:\nConcatenation is allowed only if the concatenated elements are queues or arrays:\nint q1[$], q2[$], q3[$];\nint arr1[], arr2[], arr3[];\nint arr4[][];\nq1 = {q2, q3}; // allowed\nq1 = {q2, 10}; // not allowed\narr1 = {arr2, arr3}; // allowed\narr1 = {arr2, 5}; // not allowed\narr1 = {'{1,2}, '{3,4}}; // allowed\narr1 = {{1,2}, {3,4}}; // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_4_1_6_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, empty concatenation is allowed as default value for method arguments.", name="allowAsDefaultValue", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowAsDefaultValue;

    public Check_SVTB_4_1_6_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        final LocalHidVisitor localVisitor = new LocalHidVisitor();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!namedElement.isPredefined()) {
                    RfFileDef file = namedElement.getFile();
                    if (file == null) {
                        return true;
                    }
                    if (Check_SVTB_4_1_6_1.this.isPreWaived(file.getParserPath())) {
                        return true;
                    }
                    namedElement.visitHidObject(rfProject, localVisitor);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    private IRfNamedElement getLeftHandType(RfHidOperator operator) {
        IHidObject lhValue = operator.getLHValue();
        if (lhValue == null || !(lhValue instanceof RfHid) && !(lhValue instanceof RfHidAccess) && !(lhValue instanceof RfHidImplicit)) {
            return null;
        }
        if (lhValue instanceof RfHidImplicit) {
            ISDataAbstract resolvedType = operator.getOperatorResolvedType();
            if (resolvedType == null || resolvedType instanceof DummyDataType) {
                return null;
            }
            IRfNamedElement dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType).getType();
            return dataType;
        }
        if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).isSelect()) {
            return ((RfHidAccess)lhValue).getAssociatedType();
        }
        if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).getParentHid() instanceof RfHid) {
            lhValue = ((RfHidAccess)lhValue).getParentHid();
        }
        if (!(lhValue instanceof RfHid)) {
            return null;
        }
        IRfNamedElement leftElement = ((RfHid)lhValue).getElement();
        if (leftElement == null || !(leftElement instanceof RfField)) {
            return null;
        }
        IRfNamedElement leftType = ((RfField)leftElement).getAssociatedType();
        if (leftType instanceof RfTypeAlias) {
            RfTypeAlias alias = (RfTypeAlias)leftType;
            return alias.getResolvedType(true);
        }
        return leftType;
    }

    private boolean checkAssignmentPattern(RfHidOperator assignmentPattern) {
        if (assignmentPattern == null) {
            return true;
        }
        ListContainer rightValues = assignmentPattern.getRHValues();
        if (rightValues == null || rightValues.isEmpty()) {
            return false;
        }
        for (IHidObject value : rightValues) {
            ListContainer assignedValues;
            if (!(value instanceof RfHidImplicit || value instanceof RfHid || value instanceof RfHidOperator || value instanceof RfHidAccess)) {
                return false;
            }
            if (!(value instanceof RfHidOperator)) continue;
            RfHidOperator operator = (RfHidOperator)value;
            if (operator.isVLOGConcatenation(true) && !this.checkConcatenation(operator)) {
                return false;
            }
            if (operator.isAssignmentPattern() && !this.checkAssignmentPattern(operator)) {
                return false;
            }
            if (!operator.getOperatorText().equals(":") || (assignedValues = operator.getRHValues()) == null || assignedValues.isEmpty()) continue;
            for (IHidObject assignedValue : assignedValues) {
                if (!(assignedValue instanceof RfHidOperator)) continue;
                if (((RfHidOperator)assignedValue).isAssignmentPattern() && !this.checkAssignmentPattern((RfHidOperator)assignedValue)) {
                    return false;
                }
                if (!((RfHidOperator)assignedValue).isVLOGConcatenation(true) || this.checkConcatenation((RfHidOperator)assignedValue)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkConcatenation(RfHidOperator concatenation) {
        if (concatenation == null) {
            return true;
        }
        ListContainer rightValues = concatenation.getRHValues();
        if (rightValues == null || rightValues.isEmpty()) {
            return false;
        }
        for (IHidObject concatenatedValue : rightValues) {
            if (!(concatenatedValue instanceof RfHid || concatenatedValue instanceof RfHidAccess || concatenatedValue instanceof RfHidOperator)) {
                return false;
            }
            if (concatenatedValue instanceof RfHidOperator) {
                RfHidOperator operator = (RfHidOperator)concatenatedValue;
                if (operator.isAssignmentPattern() && this.checkAssignmentPattern(operator)) continue;
                if (operator.getOperatorText().equals(":")) {
                    ListContainer assignedValue = operator.getRHValues();
                    if (assignedValue == null || assignedValue.isEmpty()) continue;
                    for (IHidObject value : assignedValue) {
                        if (!(value instanceof RfHidOperator)) continue;
                        if (((RfHidOperator)value).isAssignmentPattern() && !this.checkAssignmentPattern((RfHidOperator)value)) {
                            return false;
                        }
                        if (!((RfHidOperator)value).isVLOGConcatenation(true) || this.checkConcatenation((RfHidOperator)value)) continue;
                        return false;
                    }
                }
                return false;
            }
            IRfNamedElement concatenatedType = null;
            if (concatenatedValue instanceof RfHid) {
                IRfNamedElement concatenatedElement = ((RfHid)concatenatedValue).getElement();
                if (concatenatedElement == null || !(concatenatedElement instanceof RfField)) continue;
                concatenatedType = ((RfField)concatenatedElement).getAssociatedType();
            } else if (concatenatedValue instanceof RfHidAccess) {
                concatenatedType = ((RfHidAccess)concatenatedValue).getAssociatedType();
            }
            while (concatenatedType instanceof RfTypeAlias) {
                concatenatedType = ((RfTypeAlias)concatenatedType).getAssociatedType();
            }
            if (concatenatedType != null && concatenatedType instanceof RfListType && (((RfListType)concatenatedType).isQueue() || this.checkUnpackedDimension(((RfListType)concatenatedType).getUnpackedDimension()))) continue;
            return false;
        }
        return true;
    }

    public boolean checkUnpackedDimension(String unpackedDimension) {
        if (unpackedDimension == null || unpackedDimension.isEmpty()) {
            return false;
        }
        String lastSelect = unpackedDimension.substring(unpackedDimension.lastIndexOf("["), unpackedDimension.length());
        int indexOfColonAccess = lastSelect.lastIndexOf(":");
        if (indexOfColonAccess == -1) {
            return true;
        }
        String left = lastSelect.substring(1, indexOfColonAccess).replaceAll("\\s", "");
        String right = lastSelect.substring(indexOfColonAccess + 1, lastSelect.length() - 1).replaceAll("\\s", "");
        if (left == null || right == null) {
            return true;
        }
        return !left.equals(right);
    }

    private String getTypeName(IRfNamedElement leftValue) {
        if (!(leftValue instanceof RfListType)) {
            return "";
        }
        if (((RfListType)leftValue).isQueue()) {
            return "Queue";
        }
        if (((RfListType)leftValue).isDynamicArray()) {
            return "Dynamic array";
        }
        if (((RfListType)leftValue).isAssociativeArray()) {
            return "Associative array";
        }
        return "Array";
    }

    public boolean isPreWaived(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private static final String ERROR_MESSAGE = "{0} is assigned from concatenation!";
        private ParserPath parserPath;
        private RfNamedElement scope;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator operator = (RfHidOperator)hidObject;
            if (!operator.isEqualAssignment()) {
                return true;
            }
            Check_SVTB_4_1_6_1.this.notifyCheckAlive();
            IRfNamedElement leftHandType = Check_SVTB_4_1_6_1.this.getLeftHandType(operator);
            if (!(leftHandType instanceof RfListType) || !Check_SVTB_4_1_6_1.this.checkUnpackedDimension(((RfListType)leftHandType).getUnpackedDimension())) {
                return true;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            String typeAndName = String.valueOf(Check_SVTB_4_1_6_1.this.getTypeName(leftHandType)) + " '" + HidUtils.toNiceString((IHidObject)operator.getLHValue()) + "'";
            for (IHidObject rhValue : rhValues) {
                RfHidOperator rhOperator;
                if (rhValue instanceof RfHidImplicit && ((RfHidImplicit)rhValue).isEmptyQueue()) {
                    if (Check_SVTB_4_1_6_1.this.pAllowAsDefaultValue && this.isMethodArgument(operator)) continue;
                    Check_SVTB_4_1_6_1.this.addHit(this.parserPath, operator, operator.getQualifiers(), MessageFormat.format(ERROR_MESSAGE, typeAndName));
                    return true;
                }
                if (!(rhValue instanceof RfHidOperator) || !(rhOperator = (RfHidOperator)rhValue).isConcatOrAssignPatternOperator()) continue;
                if (rhOperator.isAssignmentPattern()) {
                    if (Check_SVTB_4_1_6_1.this.checkAssignmentPattern(rhOperator)) continue;
                    Check_SVTB_4_1_6_1.this.addHit(this.parserPath, operator, operator.getQualifiers(), MessageFormat.format(ERROR_MESSAGE, typeAndName));
                    return true;
                }
                if (!rhOperator.isVLOGConcatenation(true) || Check_SVTB_4_1_6_1.this.checkConcatenation(rhOperator)) continue;
                Check_SVTB_4_1_6_1.this.addHit(this.parserPath, operator, operator.getQualifiers(), MessageFormat.format(ERROR_MESSAGE, typeAndName));
                return true;
            }
            return true;
        }

        private boolean isMethodArgument(RfHidOperator operator) {
            if (!(this.scope instanceof RfFunction)) {
                return false;
            }
            if (!operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                return false;
            }
            RfFunction function = (RfFunction)this.scope;
            IHidObject left = operator.getLHValue();
            if (!(left instanceof RfHidImplicit)) {
                return false;
            }
            RfHidImplicit field = (RfHidImplicit)left;
            RfField argument = function.getArgumentWithPrefix(field.getName(), 1);
            return argument != null;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

