/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.5.34")
@CheckID(value="SVTB.4.1.7")
@CheckName(value="SVTB.4.1.7")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE})
@CheckTitle(value="Unsized literal values should not exceed 32-bit integer range")
@CheckDescription(value="The type of an unsized literal value is 32-bit integer. A 32-bit integer stores values between -2^31 (-2147483648) and +2^31-1 (2147483647).\nAs different simulators have different interpretations on the 2147483648 value - some warn on -2147483648, others don''t warn on +2147483648 - this rule checks that an unsized literal value is between -2147483647 and 2147483647.\nWhen using an unsized literal value with a base format, the check verifies that the value does not have more than 32 bits.\n\nAllowed:\n   bit[64:0] a1 = 'hffff_ffff;\nNot allowed:\n   bit[64:0] na1 = 2147483648;\n   bit[64:0] na2 = -2147483648;\n   bit[64:0] na3 = 'hffffffff0;\n\n  `define NUMBER 281466302889984\n   bit[64:0] na4 = `NUMBER;\n\nCheck supports pre-waiving.")
public class Check_SVTB_4_1_7
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list to skip flagging literals with specified bases. Can be one or multiple of: d, D, h, H, o, O, b, B. No default value.", name="skipLiteralsWithBase", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pSkipLiteralsWithBase;
    public static final int BIT_LENGTH_LIMIT = 32;
    public static final int BIT_LENGTH_LIMIT_NO_SPECIFIED_BASE = 31;
    private static final Pattern SIZED_LITERAL_REGEX = Pattern.compile("^\\d+'.*$");
    private static final Pattern BASE_SPECIFIED_REGEX = Pattern.compile("^'[sS]?[dDhHoObB].*$");

    public Check_SVTB_4_1_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HidOperatorVisitor hidOperatorVisitor = new HidOperatorVisitor(new HidOperatorQualifier[0]){

            public boolean visit(HidOperator operator) {
                String base;
                RfHidOperator auxiliaryOperator;
                if (!(operator instanceof RfHidOperator)) {
                    return true;
                }
                if (Check_SVTB_4_1_7.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                RfHidOperator hidOperator = (RfHidOperator)operator;
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                ListContainer rhValue = hidOperator.getRHValues();
                if (rhValue == null || rhValue.isEmpty() || rhValue.size() > 1) {
                    return true;
                }
                Check_SVTB_4_1_7.this.notifyCheckAlive();
                RfHidImplicit potentialNumber = null;
                if (rhValue.get(0) instanceof RfHidImplicit) {
                    potentialNumber = (RfHidImplicit)rhValue.get(0);
                } else if (rhValue.get(0) instanceof RfHidOperator && (auxiliaryOperator = (RfHidOperator)rhValue.get(0)).getLHValue() instanceof RfHidImplicit) {
                    potentialNumber = (RfHidImplicit)auxiliaryOperator.getLHValue();
                }
                if (potentialNumber == null || this.isSizedLiteral(potentialNumber.getName())) {
                    return true;
                }
                boolean baseSpecified = this.isBaseSpecified(potentialNumber.getName());
                if (baseSpecified && ((base = Check_SVTB_4_1_7.this.getBaseFormat(potentialNumber)).isEmpty() || Check_SVTB_4_1_7.this.pSkipLiteralsWithBase.contains(base.toLowerCase()) || Check_SVTB_4_1_7.this.pSkipLiteralsWithBase.contains(base.toUpperCase()))) {
                    return true;
                }
                Number number = potentialNumber.parseNumberValue();
                if (!(number instanceof BigInteger)) {
                    return true;
                }
                int bitLength = ((BigInteger)number).bitLength();
                if (!baseSpecified && bitLength > 31 || baseSpecified && bitLength > 32) {
                    Check_SVTB_4_1_7.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "Literal value '" + potentialNumber.getName() + "' exceeds 32-bit integer range!");
                }
                return true;
            }

            private boolean isSizedLiteral(String name) {
                return SIZED_LITERAL_REGEX.matcher(name).matches();
            }

            private boolean isBaseSpecified(String name) {
                return BASE_SPECIFIED_REGEX.matcher(name).matches();
            }
        };
        RfProject rfProject = this.fOVMProject.getRfProject();
        rfProject.visitHidObject(rfProject, (IHidVisitor<?>)hidOperatorVisitor);
    }

    private String getBaseFormat(RfHidImplicit hidImplicit) {
        String text = hidImplicit.getName();
        if (!text.contains("'")) {
            return "";
        }
        int length = text.length();
        StringBuilder base = new StringBuilder();
        int i = 0;
        while (i < length) {
            char currChar = text.charAt(i);
            if (currChar == '\'') {
                if (i + 1 >= length) {
                    return "";
                }
                char first = text.charAt(i + 1);
                if (Character.isAlphabetic(first)) {
                    if (first == 's' || first == 'S') {
                        if (++i + 1 >= length) {
                            return "";
                        }
                        base.append(text.charAt(i + 1));
                        break;
                    }
                    base.append(text.charAt(i + 1));
                    break;
                }
            }
            ++i;
        }
        return base.toString();
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

