/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.34")
@CheckID(value="SVTB.4.1.8.1")
@CheckName(value="SVTB.4.1.8.1")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.ASSIGNMENT, RuleLabel.STRUCT, RuleLabel.CONCATENATION})
@CheckTitle(value="Do not assign packed struct from concatenation")
@CheckDescription(value="Do not assign packed struct from concatenation, use struct assignment patterns '{...}\n\nExample:\nstruct packed '{\n  logic a;\n  shortint b;\n'} s;\n\nNot allowed but works, value has exactly the size of the packed struct, 17 bits\ns = { 1'b1, 16'h0 };\n\nNot allowed and doesn't work, value has 2 bits and the packed struct has 17 bits\ns = { 1'b1, 1'b1 };\n\nAllowed, struct assignment patterns are used\ns = '{ 1'b1, 1'b1 };\ns = '{ a:1'b1, b:1'b1 };\n\nCheck supports pre-waiving.")
public class Check_SVTB_4_1_8_1
extends OVMComplianceCheck {
    public Check_SVTB_4_1_8_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HidOperatorVisitor hidOperatorVisitor = new HidOperatorVisitor(new HidOperatorQualifier[0]){
            IHidHolder holder;

            /*
             * WARNING - void declaration
             */
            public boolean visit(HidOperator operator) {
                void struct;
                IRfNamedElement member;
                RfNamedElement type;
                Object arrayHid;
                if (!(operator instanceof RfHidOperator)) {
                    return true;
                }
                if (Check_SVTB_4_1_8_1.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                RfHidOperator hidOperator = (RfHidOperator)operator;
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                IHidObject lhValue = hidOperator.getLHValue();
                ListContainer rhValue = hidOperator.getRHValues();
                if (rhValue == null || rhValue.isEmpty()) {
                    return true;
                }
                Check_SVTB_4_1_8_1.this.notifyCheckAlive();
                if (!(rhValue.get(0) instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator rhHidOperator = (RfHidOperator)rhValue.get(0);
                if (!rhHidOperator.isVLOGConcatenation(true)) {
                    return true;
                }
                if (!(this.holder instanceof RfHidHolder)) {
                    return true;
                }
                IRfNamedElement enclosingScope = ((RfHidHolder)this.holder).getScope();
                if (!(enclosingScope instanceof RfNamedElement)) {
                    return true;
                }
                if (lhValue instanceof RfHidAccess) {
                    arrayHid = (RfHidAccess)lhValue;
                    if (!(arrayHid.getAssociatedType() instanceof RfNamedElement)) {
                        return true;
                    }
                    type = (RfNamedElement)arrayHid.getAssociatedType();
                    Hid parentHid = arrayHid.getParentHid();
                    if (!(parentHid instanceof RfHid)) {
                        return true;
                    }
                    member = parentHid.getElement();
                } else if (lhValue instanceof RfHidImplicit) {
                    member = ((RfNamedElement)enclosingScope).getMember(((RfHidImplicit)lhValue).getName(), null, null, true, false, false, false, false);
                    type = LintUtils.getAssociatedFinalType((RfField)member);
                } else if (lhValue instanceof RfHid) {
                    member = ((RfHid)lhValue).getElement();
                    type = LintUtils.getAssociatedFinalType((RfField)member);
                } else {
                    return true;
                }
                if (!(member instanceof RfField)) {
                    return true;
                }
                RfNamedElement rfNamedElement = type;
                if (!(rfNamedElement instanceof RfStruct) || (arrayHid = (RfStruct)rfNamedElement) != (RfStruct)rfNamedElement || !struct.isPacked() || struct.isEnum() || struct.isUnion()) {
                    return true;
                }
                Check_SVTB_4_1_8_1.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Packed struct '" + LintUtils.getNamedElementFullName((RfField)member) + "' is assigned from concatenation!");
                return true;
            }

            public void setHolder(IHidHolder holder) {
                this.holder = holder;
            }
        };
        RfProject rfProject = this.fOVMProject.getRfProject();
        rfProject.visitHidObject(rfProject, (IHidVisitor<?>)hidOperatorVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

