/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractLiteralComparison;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="21.1.11")
@CheckID(value="SVTB.4.2")
@CheckName(value="SVTB.4.2")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.COMPARISON})
@CheckTitle(value="Do not compare literals")
@CheckDescription(value="This check verifies that comparisons do not use numerical literal values.\nFor an easily maintainable code, macros, parameters or variables should be used.\nExamples:\nif (a > 2) //NOT ALLOWED\n`define VALUE 2 \nif (a > `VALUE) //ALLOWED\n\nCheck supports pre-waiving.")
public class Check_SVTB_4_2
extends AbstractLiteralComparison {
    @CheckParameter(defaultValue="", description="Comma separated list of allowed literal values for comparison.", name="allowedValues", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowedValues;

    public Check_SVTB_4_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkComparison(ParserPath path, HidOperator hidOperator, IHid lhValue, DVTPair<AbstractLiteralComparison.Type, Object> lhPair, IHid rhValue, DVTPair<AbstractLiteralComparison.Type, Object> rhPair) {
        RfHidImplicit implicit;
        if (lhPair != null && lhPair.getKey() == AbstractLiteralComparison.Type.LITERAL && lhValue instanceof RfHidImplicit && (implicit = (RfHidImplicit)lhValue).getLastReparseElement() == null && implicit.isNumber() && !this.pAllowedValues.contains(implicit.getName())) {
            this.addHit(path, (HidOccurrence)hidOperator.getOccurrence(), "Comparison of literal '" + lhValue.getName() + "' in " + HidUtils.toNiceString((IHidObject)hidOperator) + "!");
            return;
        }
        if (rhPair != null && rhPair.getKey() == AbstractLiteralComparison.Type.LITERAL && rhValue instanceof RfHidImplicit && (implicit = (RfHidImplicit)rhValue).getLastReparseElement() == null && implicit.isNumber() && !this.pAllowedValues.contains(implicit.getName())) {
            this.addHit(path, (HidOccurrence)hidOperator.getOccurrence(), "Comparison of literal '" + rhValue.getName() + "' in " + HidUtils.toNiceString((IHidObject)hidOperator) + "!");
        }
    }
}

