/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.5.10.1.1")
@CheckName(value="SVTB.5.10.1.1")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.PARAMETER, RuleLabel.PORT})
@CheckTitle(value="Do not use parameter keywords in parameter port declaration")
@CheckDescription(value="In a parameter port #(...) the use of the parameter keyword is implicit. Therefore the use of the parameter, specparam, and localparam keywords is forbidden. This simplifies code parsing by tools.\n\nNot Allowed:\n   module module_name#(parameter p=5) ();\n   class class_name#(parameter f=3, parameter type t=bit);\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_5_10_1_1
extends AbstractSVTBSimpleIssues {
    public Check_SVTB_5_10_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(15);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Parameter keyword found!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return this.fOVMProject.getSVTBIssuesWithKind(15);
    }
}

