/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_5_11_2_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractUsedFunctionReturnValueCheck;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.5.11.2.1")
@CheckName(value="SVTB.5.11.2.1")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.RETURN, RuleLabel.PREDEFINED_METHOD, RuleLabel.CAST})
@CheckTitle(value="Always use the return value of the $cast call.")
@CheckDescription(value="Return value of a $cast call must be assigned or used as argument.\n\nExamples:\n$cast( b, a ); // not allowed\nresult = $cast(col, 2 + 4); // allowed\n\nImplementation Notes:\nThis rule checks only that the return value is assigned to a variable or used as an argument to a function. It does not check what happens to the return value.\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="skipCallsCastedToVoid", description="When true, $cast calls casted to void are not checked.", isVisible=true), @CheckParameterOverride(name="skipTasks", description="When true, $cast calls inside tasks are not checked.", isVisible=true)})
@CheckAutofix(value=Autofix_SVTB_5_11_2_1.class)
public class Check_SVTB_5_11_2_1
extends AbstractUsedFunctionReturnValueCheck {
    public Check_SVTB_5_11_2_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.reportUnusedFunctionReturnValues("$cast", true);
    }
}

