/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.5.11.2.2")
@CheckName(value="SVTB.5.11.2.2")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.PREDEFINED_METHOD, RuleLabel.CLASS, RuleLabel.CAST})
@CheckTitle(value="Use $cast dynamic casting only with class objects")
@CheckDescription(value="Not all simulators support casting other data types. This rule may be obsolete as SystemVerilog support improved in all simulators.\n\nCheck supports pre-waiving.")
public class Check_SVTB_5_11_2_2
extends OVMComplianceCheck {
    private static final String CAST_FUNCTION_NAME = "$cast";

    public Check_SVTB_5_11_2_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor(this));
    }

    private class LocalHidVisitor
    extends RfHidVisitor {
        private IRfNamedElement scope;
        private OVMComplianceCheck check;

        public LocalHidVisitor(OVMComplianceCheck check) {
            this.check = check;
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public boolean visit(RfHid hidObject) {
            ListContainer rhValuesOfSecondArg;
            if (Check_SVTB_5_11_2_2.this.fOVMProject.getProjectWaivers().pathIsPrewaived(this.parserPath, this.check)) {
                return true;
            }
            Check_SVTB_5_11_2_2.this.notifyCheckAlive();
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!(hidObject.getElement() instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)hidObject.getElement();
            if (!Check_SVTB_5_11_2_2.CAST_FUNCTION_NAME.equals(function.getName())) {
                return true;
            }
            if (!(hidObject.getFirstAccess() instanceof RfHidAccessArgs)) {
                return true;
            }
            List<? extends IHidObject> argumentValues = ((RfHidAccessArgs)hidObject.getFirstAccess()).getArgumentValues();
            if (argumentValues == null || argumentValues.isEmpty()) {
                return true;
            }
            if (argumentValues.size() != 2) {
                return true;
            }
            ListContainer rhValuesOfFirstArg = ((RfHidOperator)argumentValues.get(0)).getRHValues();
            if (rhValuesOfFirstArg != null && !rhValuesOfFirstArg.isEmpty()) {
                this.checkIfArgumentAllowed((ListContainer<IHidObject>)rhValuesOfFirstArg, this.parserPath, hidObject);
            }
            if ((rhValuesOfSecondArg = ((RfHidOperator)argumentValues.get(1)).getRHValues()) != null && !rhValuesOfSecondArg.isEmpty()) {
                this.checkIfArgumentAllowed((ListContainer<IHidObject>)rhValuesOfSecondArg, this.parserPath, hidObject);
            }
            return true;
        }

        private void checkIfArgumentAllowed(ListContainer<IHidObject> arg, ParserPath parserPath, RfHid call) {
            if (arg instanceof RfHid) {
                IRfNamedElement element = ((RfHid)arg).getElement();
                if (element instanceof RfField) {
                    RfNamedElement assocType = LintUtils.getAssociatedFinalType((RfField)element, RfTypesResolver.create((IRfScopeElement)this.scope, this.scope.getRfProject(), 6));
                    if (assocType instanceof RfClass) {
                        return;
                    }
                    if (assocType != null && !(assocType instanceof RfAssociatedType.RfUnresolvedTypeInfo)) {
                        Check_SVTB_5_11_2_2.this.addHit(parserPath, call, "Not allowed $cast for '" + (((RfHid)arg).getParentAccess() == null ? element.getName() : element.getFullNameLabel()) + "'!");
                        return;
                    }
                }
            } else if (arg instanceof RfHidAccess) {
                IRfNamedElement assocType = ((RfHidAccess)arg).getAssociatedType();
                if (assocType instanceof RfClass) {
                    return;
                }
                if (assocType != null && !(assocType instanceof RfAssociatedType.RfUnresolvedTypeInfo)) {
                    Check_SVTB_5_11_2_2.this.addHit(parserPath, call, "Not allowed $cast for '" + LintUtils.removeTrailingParens(arg.toString()) + "'!");
                    return;
                }
            } else {
                Check_SVTB_5_11_2_2.this.addHit(parserPath, call, "Unknown type of '" + arg.toString() + "'!");
            }
        }
    }
}

