/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCheckCallsInIfAndAssert;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="20.1.4")
@CheckID(value="SVTB.5.11.2.3")
@CheckName(value="SVTB.5.11.2.3")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.PREDEFINED_METHOD, RuleLabel.CAST})
@CheckTitle(value="Check $cast calls")
@CheckDescription(value="The LRM does not specify a simulator runtime error in the event of failed $cast call.\nMoreover in case the $cast call fails, the destination variable is left unchanged which can lead to unexpected behavior.\nYou must check $cast failures using if or assert.\n\nExamples:\n if(!$cast(first, second))\n    `xvm_fatal( get_type_name(), \"$cast failed!\" )\n\n assert($cast(first, second)) else\n    `xvm_fatal( get_type_name(), \"$cast failed!\" )\n\n int tmp;\n tmp = $cast(first, second);\n assert(tmp) else\n    `xvm_fatal( get_type_name(), \"$cast failed!\" )\n\nImplementation Notes:\nWhen using a local variable for checking the randomization status, it is recommended to perform the check immediately after the randomize call.\nThis recommendation is not enforced by the rule.\nWhen allowTempVariableChecking is set, the rule will pass for the following example:\n\n int tmp;\n tmp = $cast(a, b);\n tmp = 1;\n assert(tmp) else\n    `xvm_fatal( get_type_name(), \"$cast failed!\")\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="skipCallsCastedToVoid", description="When true, $cast calls casted to void are not checked."), @CheckParameterOverride(name="allowOnlyIfChecking", description="When true, $cast failures must be checked using only if."), @CheckParameterOverride(name="allowTempVariableChecking", description="When true, a local variable may be used to hold the $cast status and subsequently checked."), @CheckParameterOverride(name="checkCondition", description="When true, if/assert conditions containing $cast are also checked(for if: !$cast, for assert:(!)$cast)."), @CheckParameterOverride(name="checkFailureMacros", description="Checked calls in if/assert conditions must also report potential failures using macros from this list."), @CheckParameterOverride(name="analyzeTypeParameterAccess", isVisible=false)})
public class Check_SVTB_5_11_2_3
extends AbstractCheckCallsInIfAndAssert {
    public Check_SVTB_5_11_2_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.performCallCheck("$cast");
    }

    @Override
    protected void addHitForCheck(ParserPath parserPath, HidOperatorOccurrence occurrence, String message, VerissimoAutofixAdditionalInfo verissimoAutofixAdditionalInfo) {
        this.addHit(parserPath, (HidOccurrence)occurrence, message, null);
    }

    @Override
    protected void addHitForCheck(ParserPath parserPath, int line, String message, ReparseInfo reparseInfo, VerissimoAutofixAdditionalInfo verissimoAutofixAdditionalInfo) {
        this.addHit(parserPath, line, message, reparseInfo, null);
    }
}

