/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.5.11.3")
@CheckName(value="SVTB.5.11.3")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.ARRAY, RuleLabel.CAST})
@CheckTitle(value="Do not use bit-stream casting")
@CheckDescription(value="If you need to convert an unpacked array or custom type to a bit-stream use a method.\nException: Cast from simple bit-stream type to simple bit-stream type is allowed.\nLIMITATION: Type parameters are not computed => false alarms.")
public class Check_SVTB_5_11_3
extends OVMComplianceCheck {
    private static final String FORBIDDEN_BIT_STREAM_CAST = "Forbidden bit-stream cast!";
    private static final String UNRESOLVED_CASTED_EXPRESSION_TYPE = "Unresolved casted expression type!";
    private static final String UNKNOWN_CASTING_TYPE = "Unknown casting type!";
    @CheckParameter(defaultValue="false", description="When true, casts on packed types will be skipped.", name="skipPackedTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipPackedTypes;

    public Check_SVTB_5_11_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final TypeSolver solver = new TypeSolver();
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<RfHidOperator>(){
            ParserPath parserPath;

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public boolean visit(RfHidOperator operator) {
                if (!operator.isTickCast()) {
                    return true;
                }
                IHidObject left = operator.getLHValue();
                ListContainer right = operator.getRHValues();
                IRfNamedElement castingType = solver.getType(this.parserPath, left, operator);
                if (castingType == null) {
                    this.addHitOnIssue(operator, Check_SVTB_5_11_3.UNKNOWN_CASTING_TYPE);
                    return true;
                }
                if (!this.isBitStreamType(castingType, new HashSet<String>())) {
                    return true;
                }
                IRfNamedElement castedType = this.getCastedType((ListContainer<IHidObject>)right, operator);
                if (castedType == null || castedType instanceof DummyElement && "undefined".equals(castedType.getName())) {
                    this.addHitOnIssue(operator, Check_SVTB_5_11_3.UNRESOLVED_CASTED_EXPRESSION_TYPE);
                    return true;
                }
                if (Check_SVTB_5_11_3.this.pSkipPackedTypes && this.isPackedType(castingType)) {
                    return true;
                }
                boolean isLeftSimpleBitStreamType = this.isSimpleBitStreamType(castingType);
                boolean isRightSimpleBitStreamType = this.isSimpleBitStreamType(castedType);
                if (this.isBitStreamConstant((ListContainer<IHidObject>)right) && !isLeftSimpleBitStreamType) {
                    this.addHitOnIssue(operator, Check_SVTB_5_11_3.FORBIDDEN_BIT_STREAM_CAST);
                    return true;
                }
                if (!this.isBitStreamType(castedType, new HashSet<String>())) {
                    return true;
                }
                if (isLeftSimpleBitStreamType && isRightSimpleBitStreamType) {
                    return true;
                }
                this.addHitOnIssue(operator, Check_SVTB_5_11_3.FORBIDDEN_BIT_STREAM_CAST);
                return true;
            }

            private boolean isPackedType(IRfNamedElement element) {
                if (!(element instanceof RfStruct)) {
                    return false;
                }
                return ((RfStruct)element).isPacked();
            }

            private boolean isBitStreamConstant(ListContainer<IHidObject> hidObjectList) {
                if (hidObjectList == null || hidObjectList.size() != 1) {
                    return false;
                }
                IHidObject hidObject = (IHidObject)hidObjectList.get(0);
                if (!(hidObject instanceof RfHidImplicit)) {
                    return false;
                }
                return this.isBitStreamConstant(((RfHidImplicit)hidObject).getName());
            }

            private void addHitOnIssue(RfHidOperator operator, String message) {
                HidOperatorOccurrence occurrence = operator.getOccurrence();
                if (occurrence == null) {
                    return;
                }
                Check_SVTB_5_11_3.this.addHit(this.parserPath, occurrence.getLine(), message, null);
            }

            private IRfNamedElement getCastedType(ListContainer<IHidObject> listOfObjects, RfHidOperator operator) {
                if (listOfObjects == null || listOfObjects.size() != 1) {
                    return null;
                }
                IHidObject iHidObject = (IHidObject)listOfObjects.get(0);
                return solver.getType(this.parserPath, iHidObject, operator);
            }

            private boolean isBitStreamType(IRfNamedElement type, Set<String> visitedTypes) {
                String name = type.getName();
                if (type instanceof RfAssociatedType) {
                    name = String.valueOf(name) + ((RfAssociatedType)type).getUnpackedDimension();
                    type = LintUtils.getAssociatedFinalType((RfAssociatedType)type);
                }
                if (visitedTypes.contains(name)) {
                    return true;
                }
                visitedTypes.add(name);
                if (this.isSimpleBitStreamType(type)) {
                    return true;
                }
                if (type instanceof RfClass || type instanceof RfStruct && (((RfStruct)type).isStruct() || ((RfStruct)type).isUnion() && ((RfStruct)type).isPacked())) {
                    List<RfField> fields = ((RfNamedElement)type).getLocalFields();
                    if (fields == null) {
                        return true;
                    }
                    boolean anyNotBitStream = false;
                    for (RfField field : fields) {
                        IRfNamedElement fieldType = field.getAssociatedType();
                        if (fieldType != null && this.isBitStreamType(fieldType, visitedTypes)) continue;
                        anyNotBitStream = true;
                        break;
                    }
                    if (!anyNotBitStream) {
                        return true;
                    }
                }
                return false;
            }

            private boolean isSimpleBitStreamType(IRfNamedElement type) {
                if (type instanceof RfListType && ((RfListType)type).getPackedDimension() != null && !((RfListType)type).getPackedDimension().isEmpty() && (((RfListType)type).getUnpackedDimension() == null || ((RfListType)type).getUnpackedDimension().isEmpty())) {
                    type = LintUtils.getAssociatedFinalType((RfAssociatedType)type);
                }
                if (type instanceof RfScalarType && "string".equals(type.getName())) {
                    return true;
                }
                return type instanceof RfBitVectorScalarType;
            }

            private boolean isBitStreamConstant(String value) {
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    return true;
                }
                if ("'x".equals(value) || "'z".equals(value) || "'X".equals(value) || "'Z".equals(value)) {
                    return true;
                }
                return LintUtils.isIntegralNumber(value);
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        });
    }

    class TypeSolver {
        private static final String INT = "int";
        private static final String SIGNED = "signed";
        private static final String UNSIGNED = "unsigned";
        private static final String LOGIC = "logic";

        TypeSolver() {
        }

        public IRfNamedElement getType(ParserPath parserPath, IHidObject iHidObject, RfHidOperator operator) {
            int offset;
            HidOperatorOccurrence occurence = operator.getOccurrence();
            if (occurence == null) {
                return null;
            }
            RfFileDef filedef = Check_SVTB_5_11_3.this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
            RfDefElement defScope = filedef.getScope(offset = occurence.getOffset(), true);
            if (defScope == null) {
                return null;
            }
            RfNamedElement scope = defScope.getNamedElement();
            if (iHidObject instanceof RfHid) {
                return this.getType((RfHid)iHidObject, scope);
            }
            if (iHidObject instanceof RfHidImplicit) {
                return this.getType((RfHidImplicit)iHidObject, scope);
            }
            if (iHidObject instanceof RfHidOperator) {
                return this.getType((RfHidOperator)iHidObject);
            }
            if (iHidObject instanceof RfHidAccess) {
                return this.getType((RfHidAccess)iHidObject);
            }
            return null;
        }

        private RfNamedElement getType(RfHidAccess access) {
            IRfNamedElement associatedType = access.getAssociatedType();
            if (!(associatedType instanceof RfNamedElement)) {
                return null;
            }
            return (RfNamedElement)associatedType;
        }

        private IRfNamedElement getType(RfHidOperator operator) {
            ISDataAbstract resolvedType = operator.getOperatorResolvedType();
            return this.getTypeFromDataAbstract(resolvedType);
        }

        private IRfNamedElement getTypeFromDataAbstract(ISDataAbstract resolvedType) {
            ISDataType sDataType = null;
            if (resolvedType instanceof SDataVariable) {
                SDataVariable dataVariable = (SDataVariable)resolvedType;
                sDataType = dataVariable.type;
            } else if (resolvedType instanceof ISDataType) {
                sDataType = (ISDataType)resolvedType;
            }
            if (sDataType == null) {
                return null;
            }
            IRfNamedElement type = sDataType.getType();
            return type;
        }

        private RfNamedElement getType(RfHid hid, RfNamedElement scope) {
            if (scope == null) {
                return null;
            }
            IRfNamedElement element = hid.getElement();
            if (element instanceof RfTypeAlias) {
                RfTypeAlias typeAlias = (RfTypeAlias)element;
                IRfNamedElement translatedType = typeAlias.getTranslatedType();
                if (!(translatedType instanceof RfNamedElement)) {
                    return null;
                }
                return (RfNamedElement)translatedType;
            }
            if (element instanceof RfField) {
                RfField field = (RfField)element;
                IRfNamedElement associatedType = field.getAssociatedType();
                if (associatedType instanceof RfTypeAlias) {
                    associatedType = ((RfTypeAlias)associatedType).getTranslatedType();
                }
                if (!(associatedType instanceof RfNamedElement)) {
                    return null;
                }
                return (RfNamedElement)associatedType;
            }
            if (element instanceof RfClass) {
                return (RfClass)element;
            }
            if (element instanceof RfFunction) {
                RfFunction function = (RfFunction)element;
                DataType dataType = function.getDataType();
                if (dataType == null) {
                    return null;
                }
                String type = dataType.toString();
                type = this.getActualType(type);
                return LintUtils.getTypeFromString(scope, type, true);
            }
            return null;
        }

        private String getActualType(String type) {
            if (type == null) {
                return null;
            }
            if (UNSIGNED.equals(type) || SIGNED.equals(type)) {
                type = INT;
            }
            if (type.startsWith("logic ")) {
                type = LOGIC;
            }
            return type;
        }

        private RfNamedElement getType(RfHidImplicit hidImplicit, RfNamedElement scope) {
            if (scope == null) {
                return null;
            }
            String name = hidImplicit.getName();
            if (name == null) {
                return null;
            }
            RfNamedElement typeFromString = LintUtils.getTypeFromString(scope, name = this.getActualType(name), true);
            if (typeFromString != null) {
                return typeFromString;
            }
            String guessedTypeName = hidImplicit.guessTypeName(true);
            if (guessedTypeName == null && hidImplicit.isNumber() && hidImplicit.getType() != 283) {
                guessedTypeName = INT;
            }
            return LintUtils.getTypeFromString(scope, guessedTypeName, true);
        }
    }
}

