/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="19.1.35")
@CheckID(value="SVTB.5.12.1")
@CheckName(value="SVTB.5.12.1")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.PARAMETER})
@CheckTitle(value="Do not use untyped parameters")
@CheckDescription(value="Do not use untyped or typed inferred parameters.\n\nAllowed:\nparameter int p1 = 123;\nparameter enum_t p2 = ENUM_VALUE;\n#(int a = 8, bit b = 0, type c = type_t)\n\nNot Allowed:\nparameter p1 = 123;\n#(a = 8, b = 0, c = type_t)")
public class Check_SVTB_5_12_1
extends OVMComplianceCheck {
    public Check_SVTB_5_12_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NamedElementVisitor visitor = new NamedElementVisitor(this);
        this.fOVMProject.getRfProject().accept(visitor);
    }

    private final class NamedElementVisitor
    implements IRfNamedElementVisitor {
        OVMComplianceCheck check;

        public NamedElementVisitor(OVMComplianceCheck check) {
            this.check = check;
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfField)) {
                return true;
            }
            RfDefElement declaration = namedElement.getDeclaration();
            if (declaration == null) {
                return true;
            }
            if (Check_SVTB_5_12_1.this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this.check)) {
                return true;
            }
            Check_SVTB_5_12_1.this.notifyCheckAlive();
            RfField rfField = (RfField)namedElement;
            DataType dataType = rfField.getDataType();
            if (rfField.isSpecParam()) {
                return true;
            }
            if (rfField.isParameterNoDataType() || (rfField.isParameter() || rfField.isTypeParameter()) && dataType != null && dataType.isInherited()) {
                Check_SVTB_5_12_1.this.addHit(namedElement, "Parameter '" + LintUtils.getNamedElementFullName(namedElement) + "' does not have a type!");
            }
            return true;
        }
    }
}

