/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="19.1.35")
@CheckID(value="SVTB.5.13")
@CheckName(value="SVTB.5.13")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.ENUM, RuleLabel.STRING, RuleLabel.COMPARISON})
@CheckTitle(value="Do not use enum.name() in comparisons")
@CheckDescription(value="Do not use enum.name() in comparisons.\nA common bug is to compare the enum name (string) with the enum value (numeric).\nAlso, comparing the names instead of the actual values is ineficient.\n\nExample:\ntypedef enum { E1, E2, E3 } enum_t;\nenum_t x;\nif (x.name() == E1) // Not allowed and also a bug\nif (x.name() == \"E1\") // Not allowed\nif (x == E1) // Allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_5_13
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of macro name patterns. Comparisons done inside macros that match any of the specified patterns will be skipped.", name="skipMacroPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pSkipMacroPatterns;
    private static final Set<Integer> OPERATOR_TYPE_TOKENS = new HashSet<Integer>(Arrays.asList(482, 483, 484, 485, 502, 504, 486, 487, 488, 489, 128));
    private final HidOperatorVisitor comparisonVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidOperator) {
            Collection<String> enclosingMacroNames;
            int operatorType = hidOperator.getOperatorType();
            if (!OPERATOR_TYPE_TOKENS.contains(operatorType)) {
                return true;
            }
            if (this.scope == null || !(this.scope instanceof RfNamedElement)) {
                return true;
            }
            if (Check_SVTB_5_13.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (this.isInConstraint((RfNamedElement)this.scope)) {
                return true;
            }
            Check_SVTB_5_13.this.notifyCheckAlive();
            if (!Check_SVTB_5_13.this.pSkipMacroPatterns.isEmpty() && (enclosingMacroNames = this.getEnclosingMacroNames(hidOperator)) != null) {
                for (String macroName : enclosingMacroNames) {
                    if (macroName == null) continue;
                    for (Pattern pattern : Check_SVTB_5_13.this.pSkipMacroPatterns) {
                        Matcher m = pattern.matcher(macroName);
                        if (!m.matches()) continue;
                        return true;
                    }
                }
            }
            IHidObject lhValue = hidOperator.getLHValue();
            Check_SVTB_5_13.this.checkForPredefinedNameMethod(this.parserPath, lhValue);
            IHidObject rhValue = hidOperator.getFirstRHValue();
            if (rhValue == null) {
                return true;
            }
            Check_SVTB_5_13.this.checkForPredefinedNameMethod(this.parserPath, rhValue);
            return true;
        }

        private boolean isInConstraint(RfNamedElement scope) {
            while (scope != null) {
                if (scope instanceof RfConstraint || scope instanceof RfActionBlock && ((RfActionBlock)scope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.WITH)) {
                    return true;
                }
                scope = scope.getEnclosingScope();
            }
            return false;
        }

        private Collection<String> getEnclosingMacroNames(HidOperator hid) {
            ArrayList<String> enclosingMacroNames = new ArrayList<String>();
            IReparseInfo iReparseInfo = hid.getReparseInfo();
            if (iReparseInfo == null) {
                return null;
            }
            if (!(iReparseInfo instanceof ReparseInfo)) {
                return null;
            }
            ReparseInfo reparseInfo = (ReparseInfo)iReparseInfo;
            ReparseInfo.ReparseElement[] reparseElementArray = reparseInfo.getReparseStack();
            int n = reparseElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReparseInfo.ReparseElement reparseElement = reparseElementArray[n2];
                enclosingMacroNames.add(reparseElement.getReparseMacroName());
                ++n2;
            }
            return enclosingMacroNames;
        }
    };

    public Check_SVTB_5_13(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    private void checkForPredefinedNameMethod(ParserPath parserPath, IHidObject hidObject) {
        IRfScopeElement functionScope;
        IRfNamedElement element;
        if (hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).isVLOGConcatenation(false)) {
            ArrayList<IHidObject> concatOperands = new ArrayList<IHidObject>();
            concatOperands.add(((RfHidOperator)hidObject).getLHValue());
            for (IHidObject rhValue : ((RfHidOperator)hidObject).getRHValues()) {
                concatOperands.add(rhValue);
            }
            for (IHidObject operand : concatOperands) {
                this.checkForPredefinedNameMethod(parserPath, operand);
            }
        } else if (hidObject instanceof RfHidAccess && (hidObject = ((RfHidAccess)hidObject).getParentHid()) instanceof RfHid && ((RfHid)hidObject).isMethodCall(false) && ((RfHid)hidObject).getName().equals("name") && (element = ((RfHid)hidObject).getElement()) instanceof RfPredefinedFunction && (functionScope = element.getEnclosingScope()) instanceof RfStruct && ((RfStruct)functionScope).isEnum()) {
            this.addHit(parserPath, ((RfHid)hidObject).getOccurrence(), "Comparison of enum variable method '" + HidUtils.toNiceString((IHidObject)hidObject) + "'!");
        }
    }

    @Override
    public void performCheckImpl() {
        final RfProject rfProject = this.fOVMProject.getRfProject();
        rfProject.visitHidObject(null, (IHidVisitor<?>)this.comparisonVisitor);
        rfProject.accept(new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfActionBlock)) {
                    return true;
                }
                if (namedElement.getFile() != null && Check_SVTB_5_13.this.checkPreWaivers(namedElement.getFile().getParserPath())) {
                    return true;
                }
                if (((RfActionBlock)namedElement).isCase() || ((RfActionBlock)namedElement).isCaseItem()) {
                    RfHidHolder hidHolder = namedElement.getHidHolder();
                    if (hidHolder == null) {
                        return true;
                    }
                    hidHolder.visitHidObject(rfProject, (IHidVisitor)new IHidVisitor<IHidObject>(){
                        ParserPath parserPath;

                        public boolean visit(IHidObject hidObject) {
                            if (hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).isCaseCondition()) {
                                IHidObject lhValue = ((RfHidOperator)hidObject).getLHValue();
                                Check_SVTB_5_13.this.checkForPredefinedNameMethod(this.parserPath, lhValue);
                            } else if (hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).isCaseItemCondition()) {
                                IHidObject rhValue = ((RfHidOperator)hidObject).getFirstRHValue();
                                if (rhValue == null) {
                                    return true;
                                }
                                Check_SVTB_5_13.this.checkForPredefinedNameMethod(this.parserPath, rhValue);
                            }
                            return true;
                        }

                        public Class<IHidObject> getType() {
                            return IHidObject.class;
                        }

                        public void setParserPath(ParserPath parserPath) {
                            this.parserPath = parserPath;
                        }
                    });
                }
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

