/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.VlogProblemKinds;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;

@CheckVersion(value="20.1.14")
@CheckID(value="SVTB.5.14")
@CheckName(value="SVTB.5.14")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.ENUM, RuleLabel.OPERATOR})
@CheckTitle(value="Matching types for enum variables used in equality operators")
@CheckDescription(value="Enum variables used in equality operators should have matching types.\n\nExamples:\ntypedef enum { SMALL, LARGE } size_e;\ntypedef enum { READ, WRITE } direction_e;\n\nclass packet;\n\tdirection_e direction;\n\trand size_e size;\nendclass\n\nfunction f();\n\tpacket p1;\n\tp1.size = READ; // not allowed\n\tp1.size = SMALL; // allowed\n\n\tp1.direction = WRITE; // allowed\n\tp1.direction = SMALL; // not allowed\n\nendfunction\n")
public class Check_SVTB_5_14
extends OVMComplianceCheck {
    private static Set<String> checkedTags = new HashSet<String>();

    static {
        checkedTags.add(Check_SVTB_5_14.getTag("IMPLICIT_ENUM_CAST: Auto-cast from enum type {0} to enum type {1}"));
        checkedTags.add(Check_SVTB_5_14.getTag(RfSemanticError.NON_STANDARD_ENUM_ASSIGNMENT));
        checkedTags.add(Check_SVTB_5_14.getTag(RfSemanticError.NON_STANDARD_ENUM_COMPARISON));
        checkedTags.add(Check_SVTB_5_14.getTag(RfSemanticError.NON_STANDARD_ENUM_RETURN));
        checkedTags.add(Check_SVTB_5_14.getTag(RfSemanticError.NON_STANDARD_DIFFERENT_ENUMS_ASSIGNMENT));
        checkedTags.add(Check_SVTB_5_14.getTag(RfSemanticError.NON_STANDARD_DIFFERENT_ENUMS_COMPARISON));
    }

    public Check_SVTB_5_14(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Collection allSemanticWarnings = DVTProblemManager.getInstance().getAllProblems(this.getIProject(), DVTProblemMatcher.all().setKind(VlogProblemKinds.SEMANTIC_WARNING.getId()), null);
        for (DVTProblem warning : allSemanticWarnings) {
            String problemTag;
            String message = warning.getMessage();
            if (warning.getMessage() == null || !checkedTags.contains(problemTag = Check_SVTB_5_14.getTag(message))) continue;
            this.addHit(new ParserPath(warning.getPath()), warning.getLine(), Check_SVTB_5_14.formatMessage(message), null);
        }
    }

    private static String getTag(String message) {
        int index = message.indexOf(58);
        if (index == -1) {
            return message;
        }
        return message.substring(0, index);
    }

    private static String formatMessage(String message) {
        int index = message.indexOf(58);
        if (index == -1 || index >= message.length()) {
            return message;
        }
        return message.substring(index + 1);
    }
}

