/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.5.1.1")
@CheckName(value="SVTB.5.1.1")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.INTERFACE, RuleLabel.DESIGN})
@CheckTitle(value="Use wire only in interfaces for multiple drivers")
@CheckDescription(value="Do not use type wire in anything other than an interface.\nWire is a 4 state bit. Use it in interfaces only when the logic type does not work, that is in the case of multiple drivers within an interface a wire must be used (inout ports cannot be of type ''logic'').\n\nExamples:\nmodule my_module;\n\twire a; // not allowed\nendmodule\n\ninterface my_interface;\n\twire b; // allowed\nendinterface\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_5_1_1
extends OVMComplianceCheck {
    private static final String WIRE = "wire";
    private Set<RfField> allFieldsToCheck = new HashSet<RfField>();
    @CheckParameter(defaultValue="false", description="When true, wire connections in modules that connect instances are not flagged.", name="allowModuleWireConnections", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowModuleWireConnections;

    public Check_SVTB_5_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected String getFailMessage(String name) {
        return this.pAllowModuleWireConnections ? "Wire '" + name + "' used outside an interface or module instance connection!" : "Wire '" + name + "' used outside an interface!";
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(namedElement -> {
            this.notifyCheckAlive();
            RfDefElement defElement = namedElement.getDeclaration();
            if (defElement == null) {
                return true;
            }
            if (this.checkPreWaivers(defElement.getParserPath())) {
                return true;
            }
            boolean isModule = namedElement instanceof RfModule;
            if (!isModule && !(namedElement instanceof RfProgram)) {
                return true;
            }
            Collection<RfNamedElement> members = namedElement.getMembers();
            if (members == null) {
                return true;
            }
            for (RfNamedElement member : members) {
                RfNamedElement scope;
                RfField field;
                DataType type;
                if (!(member instanceof RfField) || (type = (field = (RfField)member).getDataType()) == null || !WIRE.equals(type.getNetType())) continue;
                if (isModule && this.pAllowModuleWireConnections && (scope = field.getEnclosingScope()) instanceof RfModule) {
                    this.allFieldsToCheck.add(field);
                    continue;
                }
                this.addHit(field, this.getFailMessage(field.getName()));
            }
            return true;
        });
        if (this.pAllowModuleWireConnections) {
            IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.fOVMProject.getProject());
            ElabMemoryVisitor visitor = new ElabMemoryVisitor(this.allFieldsToCheck, this);
            memory.visitBindings((IELMemory.IELMemoryVisitor)visitor);
            for (RfField fieldUsage : visitor.getFieldsUsage()) {
                this.addHit(fieldUsage, this.getFailMessage(fieldUsage.getName()));
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static final class ElabMemoryVisitor
    implements IELMemory.IELMemoryVisitor {
        private Set<RfField> areFieldsUsed = new HashSet<RfField>();
        private OVMComplianceCheck check;

        public ElabMemoryVisitor(Set<RfField> searchCache, OVMComplianceCheck check) {
            this.areFieldsUsed = searchCache;
            this.check = check;
        }

        public boolean visitBindings(ElementPath path, ELInstance instance) {
            IRfInstanceElement instanceDescription = instance.getDescription();
            if (!(instanceDescription instanceof RfInstance)) {
                return true;
            }
            Iterator<RfField> areFieldsUsedIterator = this.areFieldsUsed.iterator();
            block0: while (areFieldsUsedIterator.hasNext()) {
                RfField field = areFieldsUsedIterator.next();
                this.check.notifyCheckAlive();
                RfNamedElement elemToCheck = field;
                if (field instanceof RfPort) {
                    elemToCheck = field.getEnclosingScope();
                    if (!(elemToCheck instanceof RfModule) || !instance.getBinding(false).equals(elemToCheck)) continue;
                    areFieldsUsedIterator.remove();
                    continue;
                }
                IHidHolder holder = instanceDescription.getHidHolder();
                if (!(holder instanceof RfHidHolder)) {
                    return true;
                }
                RfHidHolder rfHolder = (RfHidHolder)holder;
                Map hidObjectsMap = rfHolder.getHidObjectsMap();
                boolean didRemove = false;
                for (ListContainer hidObjects : hidObjectsMap.values()) {
                    for (IHidObject hidObject : hidObjects) {
                        boolean isUsed;
                        if (!(hidObject instanceof RfHidOperator) || !(isUsed = this.checkIsInstantiatedPort(instance, (RfHidOperator)hidObject, field))) continue;
                        areFieldsUsedIterator.remove();
                        didRemove = true;
                        break;
                    }
                    if (didRemove) continue block0;
                }
            }
            return true;
        }

        private boolean checkIsInstantiatedPort(ELInstance instance, RfHidOperator operator, RfNamedElement element) {
            IRfNamedElement binding;
            List<RfPort> ports;
            if (!operator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION)) {
                return false;
            }
            for (IHidObject hidObject : operator.getRHValues()) {
                if (!(hidObject instanceof RfHid) || !element.equals(((RfHid)hidObject).getElement())) continue;
                return true;
            }
            if (operator.getLHValue() instanceof RfHidImplicit && ((RfHidImplicit)operator.getLHValue()).isDotStarAssociation() && (ports = ((RfNamedElement)(binding = instance.getBinding(false))).getPortsWithPrefix("", 2)).stream().map(RfNamedElement::getName).collect(Collectors.toSet()).contains(element.getName())) {
                return true;
            }
            if (operator.getLHValue() instanceof RfHid) {
                return ((RfHid)operator.getLHValue()).getName().equals(element.getName());
            }
            return false;
        }

        public Set<RfField> getFieldsUsage() {
            return this.areFieldsUsed;
        }
    }
}

