/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;

@CheckVersion(value="16.1.30")
@CheckID(value="SVTB.5.1.2")
@CheckName(value="SVTB.5.1.2")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.DIRECTIVE, RuleLabel.DESIGN})
@CheckTitle(value="Use `default_nettype none to force explicitly declared nets")
@CheckDescription(value="It check that `default_nettype none is applied to all design elements (module , program , interface, checker, package, primitive, config).\n\nCheck supports pre-waiving.")
public class Check_SVTB_5_1_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="10", description="Maximum number of hits to be reported. This is used to limit the number of hits when no `default_nettype none is specified.", name="maxNofHits", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int maxNofHitsValue;
    private int nofHits;

    public Check_SVTB_5_1_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.nofHits = 0;
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                Check_SVTB_5_1_2.this.notifyCheckAlive();
                if (Check_SVTB_5_1_2.this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                String variable = System.getenv("VERISSIMO_DEBUG_SVTB_5_1_2");
                if (variable != null && variable.equalsIgnoreCase("true")) {
                    DVTLogger.INSTANCE.logDebug(String.valueOf(LintUtils.getElementKind(namedElement)) + ": '" + LintUtils.getNamedElementFullName(namedElement) + "' has default nettype: " + namedElement.getDefaultNetType(namedElement));
                }
                if (Check_SVTB_5_1_2.this.maxNofHitsValue > Check_SVTB_5_1_2.this.nofHits && (namedElement instanceof RfModule || namedElement instanceof RfProgram || namedElement instanceof RfInterface || namedElement instanceof RfChecker || namedElement instanceof RfPackage || namedElement instanceof RfPrimitive || namedElement instanceof RfConfiguration) && !namedElement.isPredefined() && !Check_SVTB_5_1_2.this.fOVMProject.isOVMElement(namedElement) && !namedElement.getDefaultNetType(namedElement).equals("none")) {
                    Check_SVTB_5_1_2.this.addHit(namedElement, "Default nettype for " + LintUtils.getElementKind(namedElement) + " '" + LintUtils.getNamedElementFullName(namedElement) + "' must be none");
                    if (variable != null && variable.equalsIgnoreCase("true")) {
                        DVTLogger.INSTANCE.logDebug("Hit no: " + Check_SVTB_5_1_2.this.nofHits + " on " + LintUtils.getElementKind(namedElement) + ": '" + LintUtils.getNamedElementFullName(namedElement) + "'");
                    }
                    ++Check_SVTB_5_1_2.this.nofHits;
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().accept(neVisitor);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

