/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFourStateCastCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.5.2.7")
@CheckName(value="SVTB.5.2.7")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.ARGUMENT, RuleLabel._4_STATE, RuleLabel.CAST})
@CheckTitle(value="Assignments from 4 state to 2 state must include X,Z check")
@CheckDescription(value="SystemVerilog does not require a compiler check when assigning (or casting) from 4 state to 2 state types.\nWhen an X or Z is assigned to a 2 state type the value is silently converted to 0.\nSince this is not typically intended, it is recommended to frame any 4 state to 2 state assignment with a check for X or Z.\n\nExample:\nif (^my_logic_vector === 1'bX) begin\n  //... fatal error - found X or Z prior to assign to 2 state type ...\nend\nelse begin\n  my_bit_vector = my_logic_vector;\nend\n\nImplementation Notes:\n By default this rule checks that 4-state to 2-state assignments are placed within a conditional block. It also checks that the if condition expression contains the right hand side variable of the assignment.\n When useIsUnknownGuard is true, the assignment must be placed within an if action block with the $isunknown(name) condition.\n\nCheck supports pre-waiving.")
public class Check_SVTB_5_2_7
extends AbstractFourStateCastCheck {
    @CheckParameter(defaultValue="[scalar].string.atoi, [scalar].string.atohex, [scalar].string.atooct, [scalar].string.atobin, $test$plusargs, $value$plusargs, $rtoi, $bits, $left, $right, $low, $high, $increment, $size, $clog2", description="Comma separated list of full names of methods whose return value assignment to a 2-state variable will be skipped.", name="skipMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pSkipMethodsValue = new HashSet();
    @CheckParameter(defaultValue="false", description="When true, assignments with a parameter on the right hand side will be ignored.", name="skipParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipParameters;
    @CheckParameter(defaultValue="false", description="When true, assignments checked in a ternary conditional are allowed.", name="allowTernaryConditionalChecks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowTernaryConditionalChecks;
    private Set<Integer> alwaysTwoStateOperators = new HashSet<Integer>(Arrays.asList(484, 485));
    private final HidOperatorVisitor assignmentsVisitor = new HidOperatorVisitor(null){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean visit(HidOperator hidObject) {
            if (!hidObject.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS) && !hidObject.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                return true;
            }
            if (this.scope == null || !(this.scope instanceof RfNamedElement)) {
                return true;
            }
            if (Check_SVTB_5_2_7.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            HidOperator hidOperator = hidObject;
            IHidObject lhHidObject = hidOperator.getLHValue();
            IRfNamedElement lhType = null;
            Check_SVTB_5_2_7.this.notifyCheckAlive();
            if (!hidObject.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                if (lhHidObject instanceof RfHidAccess) {
                    lhType = ((RfHidAccess)lhHidObject).getAssociatedType();
                } else if (lhHidObject instanceof RfHid) {
                    IRfNamedElement lhElement = ((IHid)lhHidObject).getElement();
                    if (!(lhElement instanceof RfAssociatedType)) {
                        return true;
                    }
                    lhType = ((RfAssociatedType)lhElement).getAssociatedType();
                } else {
                    if (!(lhHidObject instanceof RfHidOperator)) return true;
                    lhType = this.getOperatorType((RfHidOperator)lhHidObject);
                }
            } else {
                lhType = this.getOperatorType(hidOperator);
            }
            if (lhType == null) {
                return true;
            }
            if (LintUtils.isFourStateType(lhType, Check_SVTB_5_2_7.this.pHandleTimeAsFourStateValue)) {
                return true;
            }
            ListContainer rhValues = hidOperator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            IRfNamedElement rhType = null;
            if (rhValue instanceof RfHidAccessArgs) {
                rhValue = ((RfHidAccessArgs)rhValue).getParentHid();
            }
            if (rhValue instanceof RfHidAccess) {
                if (this.checkAccessForParameters((RfHidAccess)rhValue)) {
                    return true;
                }
                rhType = ((RfHidAccess)rhValue).getAssociatedType();
            } else if (rhValue instanceof RfHid) {
                IRfNamedElement rhElement = ((IHid)rhValue).getElement();
                if (!(rhElement instanceof RfAssociatedType)) {
                    return true;
                }
                if (Check_SVTB_5_2_7.this.pSkipMethodsValue.contains(LintUtils.getNamedElementFullName((RfAssociatedType)rhElement))) {
                    return true;
                }
                if (this.checkHidForParameters((RfHid)rhValue)) {
                    return true;
                }
                rhType = ((RfAssociatedType)rhElement).getAssociatedType();
            } else if (rhValue instanceof RfHidImplicit) {
                if (this.isImplicitAmbiguous((RfHidImplicit)rhValue) && !LintUtils.isInConditionalActionBlock((IRfScope)this.scope)) {
                    Check_SVTB_5_2_7.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), String.valueOf(Check_SVTB_5_2_7.this.getFailMessage()) + HidUtils.toNiceString((IHidObject)hidOperator));
                }
            } else {
                if (!(rhValue instanceof RfHidOperator)) return true;
                RfHidOperator op = (RfHidOperator)rhValue;
                boolean opIs4State = this.analyzeImplicitsInExpressions(op);
                if (!opIs4State) {
                    return true;
                }
                if (!LintUtils.isInConditionalActionBlock((IRfScope)this.scope)) {
                    Check_SVTB_5_2_7.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), String.valueOf(Check_SVTB_5_2_7.this.getFailMessage()) + hidOperator.toString());
                    return true;
                }
                IHidObject ifObject = Check_SVTB_5_2_7.this.getFirstConditionalWithExpressionBlock((IRfScope)this.scope);
                if (ifObject == null) {
                    return true;
                }
                Set allRhHids = op.getLHHids(HidFlatteningOption.IMPLICITS_SELECTS_AND_ARGS_EXCLUDED);
                allRhHids.addAll(op.getRHHids(HidFlatteningOption.IMPLICITS_SELECTS_AND_ARGS_EXCLUDED));
                Check_SVTB_5_2_7.this.checkConditionalActionBlock(this.scope, ifObject);
                Set associatedFields = (Set)Check_SVTB_5_2_7.this.fields.get(this.scope);
                boolean ok = false;
                for (IHid hid : allRhHids) {
                    if (!(hid instanceof RfHid) || !associatedFields.contains(hid)) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    Check_SVTB_5_2_7.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), String.valueOf(Check_SVTB_5_2_7.this.getFailMessage()) + hidOperator.toString());
                }
            }
            if (rhType == null) {
                return true;
            }
            if (!LintUtils.isFourStateType(rhType, Check_SVTB_5_2_7.this.pHandleTimeAsFourStateValue)) {
                return true;
            }
            if (!LintUtils.isInConditionalActionBlock((IRfScope)this.scope)) {
                Check_SVTB_5_2_7.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), String.valueOf(Check_SVTB_5_2_7.this.getFailMessage()) + hidOperator.toString());
                return true;
            }
            if (rhValue instanceof RfHidAccess) {
                rhValue = ((RfHidAccess)rhValue).getParentHid();
            }
            if (!(rhValue instanceof RfHid)) {
                return true;
            }
            RfHid rhHid = (RfHid)rhValue;
            IHidObject ifObject = Check_SVTB_5_2_7.this.getFirstConditionalWithExpressionBlock((IRfScope)this.scope);
            if (ifObject == null) {
                return true;
            }
            Check_SVTB_5_2_7.this.checkConditionalActionBlock(this.scope, ifObject);
            Set associatedFields = (Set)Check_SVTB_5_2_7.this.fields.get(this.scope);
            if (associatedFields.contains((Object)rhHid)) return true;
            Check_SVTB_5_2_7.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), String.valueOf(Check_SVTB_5_2_7.this.getFailMessage()) + hidOperator.toString());
            return true;
        }

        private boolean checkAccessForParameters(RfHidAccess hid) {
            return hid.getParentHid() != null && hid.getParentHid().getElement() instanceof RfField && ((RfField)hid.getParentHid().getElement()).isParameter() && (Check_SVTB_5_2_7.this.pSkipParameters || ((RfField)hid.getParentHid().getElement()).isParameterNoDataType());
        }

        private boolean checkHidForParameters(RfHid hid) {
            IRfNamedElement rhElement = hid.getElement();
            return rhElement instanceof RfField && ((RfField)rhElement).isParameter() && (Check_SVTB_5_2_7.this.pSkipParameters || ((RfField)rhElement).isParameterNoDataType());
        }

        private boolean isImplicitAmbiguous(RfHidImplicit hid) {
            String numberString = hid.getName();
            return hid.isNumber() && hid.getType() != 283 && (numberString.toUpperCase().contains("X") || numberString.toUpperCase().contains("Z"));
        }

        private boolean isAccess4State(RfHidAccess hid) {
            IRfNamedElement rhType = hid.getAssociatedType();
            if (rhType == null) {
                return false;
            }
            if (hid instanceof RfHidAccessArgs) {
                IRfNamedElement rhElement = ((RfHidAccessArgs)hid).getParentHid().getElement();
                if (!(rhElement instanceof RfAssociatedType)) {
                    return false;
                }
                if (Check_SVTB_5_2_7.this.pSkipMethodsValue.contains(LintUtils.getNamedElementFullName((RfAssociatedType)rhElement))) {
                    return false;
                }
            }
            if (this.checkAccessForParameters(hid)) {
                return false;
            }
            return LintUtils.isFourStateType(rhType, Check_SVTB_5_2_7.this.pHandleTimeAsFourStateValue);
        }

        private boolean isHid4State(RfHid hid) {
            IRfNamedElement rhElement = hid.getElement();
            if (!(rhElement instanceof RfAssociatedType)) {
                return false;
            }
            if (Check_SVTB_5_2_7.this.pSkipMethodsValue.contains(LintUtils.getNamedElementFullName((RfAssociatedType)rhElement))) {
                return false;
            }
            if (this.checkHidForParameters(hid)) {
                return false;
            }
            IRfNamedElement rhType = ((RfAssociatedType)rhElement).getAssociatedType();
            if (rhType == null) {
                return true;
            }
            return LintUtils.isFourStateType(rhType, Check_SVTB_5_2_7.this.pHandleTimeAsFourStateValue);
        }

        private boolean analyzeImplicitsInExpressions(RfHidOperator operator) {
            if (Check_SVTB_5_2_7.this.pAllowTernaryConditionalChecks && operator.isConditionalTernary() && this.analyzeTernaryConditional(operator)) {
                return false;
            }
            if (Check_SVTB_5_2_7.this.alwaysTwoStateOperators.contains(operator.getOperatorType())) {
                return false;
            }
            if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR || operator.isTickCast()) {
                IHidObject value = operator.getLHValue();
                if (value instanceof RfHidImplicit && this.isImplicitAmbiguous((RfHidImplicit)value) || value instanceof RfHid && this.isHid4State((RfHid)value) || value instanceof RfHidAccess && this.isAccess4State((RfHidAccess)value) || value instanceof RfHidOperator && this.analyzeImplicitsInExpressions((RfHidOperator)value)) {
                    return true;
                }
            } else if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                IHidObject lValue = operator.getLHValue();
                IHidObject rValue = (IHidObject)operator.getRHValues().get(0);
                if (lValue instanceof RfHidImplicit && this.isImplicitAmbiguous((RfHidImplicit)lValue) || rValue instanceof RfHidImplicit && this.isImplicitAmbiguous((RfHidImplicit)rValue)) {
                    return true;
                }
                if (lValue instanceof RfHid && this.isHid4State((RfHid)lValue) || rValue instanceof RfHid && this.isHid4State((RfHid)rValue)) {
                    return true;
                }
                if (lValue instanceof RfHidAccess && this.isAccess4State((RfHidAccess)lValue) || rValue instanceof RfHidAccess && this.isAccess4State((RfHidAccess)rValue)) {
                    return true;
                }
                if (lValue instanceof RfHidOperator && this.analyzeImplicitsInExpressions((RfHidOperator)lValue) || rValue instanceof RfHidOperator && this.analyzeImplicitsInExpressions((RfHidOperator)rValue)) {
                    return true;
                }
            } else if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR && operator.isConditionalTernary()) {
                IHidObject rh0Value = (IHidObject)operator.getRHValues().get(0);
                IHidObject rh1Value = (IHidObject)operator.getRHValues().get(1);
                if (rh0Value instanceof RfHidImplicit && this.isImplicitAmbiguous((RfHidImplicit)rh0Value) || rh1Value instanceof RfHidImplicit && this.isImplicitAmbiguous((RfHidImplicit)rh1Value)) {
                    return true;
                }
                if (rh0Value instanceof RfHid && this.isHid4State((RfHid)rh0Value) || rh1Value instanceof RfHid && this.isHid4State((RfHid)rh1Value)) {
                    return true;
                }
                if (rh0Value instanceof RfHidAccess && this.isAccess4State((RfHidAccess)rh0Value) || rh1Value instanceof RfHidAccess && this.isAccess4State((RfHidAccess)rh1Value)) {
                    return true;
                }
                if (rh0Value instanceof RfHidOperator && this.analyzeImplicitsInExpressions((RfHidOperator)rh0Value) || rh1Value instanceof RfHidOperator && this.analyzeImplicitsInExpressions((RfHidOperator)rh1Value)) {
                    return true;
                }
            } else if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                for (IHidObject val : operator.getRHValues()) {
                    if (!(val instanceof RfHidImplicit && this.isImplicitAmbiguous((RfHidImplicit)val) || val instanceof RfHid && this.isHid4State((RfHid)val) || val instanceof RfHidAccess && this.isAccess4State((RfHidAccess)val)) && (!(val instanceof RfHidOperator) || !this.analyzeImplicitsInExpressions((RfHidOperator)val))) continue;
                    return true;
                }
            }
            return false;
        }

        private IRfNamedElement getOperatorType(HidOperator operator) {
            ISDataAbstract resolvedType = operator.getOperatorResolvedType();
            if (resolvedType == null) {
                return null;
            }
            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
            if (dataType == null) {
                return null;
            }
            return SDataUtils.getUndefinedDataType((ISDataAbstract)dataType) == null ? dataType.getType() : null;
        }

        /*
         * WARNING - void declaration
         */
        private boolean analyzeTernaryConditional(RfHidOperator op) {
            HashSet<RfHid> checkedHids = new HashSet<RfHid>();
            ArrayList<RfHid> leftHids = new ArrayList<RfHid>();
            IHidObject lhValue = op.getLHValue();
            Set hids = HidUtils.flattenToHids((IHidObject)lhValue, EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
            for (IHid iHid : hids) {
                if (!(iHid instanceof RfHid)) continue;
                leftHids.add((RfHid)iHid);
            }
            if (Check_SVTB_5_2_7.this.pUseIsUnknownGuardValue) {
                for (RfHid rfHid : leftHids) {
                    IRfNamedElement iRfNamedElement = rfHid.getElement();
                    if (!(iRfNamedElement instanceof RfPredefinedFunction) || !"$isunknown".equals(iRfNamedElement.getName())) continue;
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                    for (MethodCall methodCall : methodCalls) {
                        if (methodCall.argumentValuesMap == null) continue;
                        for (Map.Entry argumentEntry : methodCall.argumentValuesMapRaw.entrySet()) {
                            Hid parentHid;
                            IRfNamedElement argumentKey = (IRfNamedElement)argumentEntry.getKey();
                            if (argumentKey == null || !argumentKey.getName().equals("expression")) continue;
                            IHidObject value = (IHidObject)argumentEntry.getValue();
                            if (value instanceof RfHid) {
                                checkedHids.add((RfHid)value);
                                continue;
                            }
                            if (!(value instanceof RfHidAccess) || !((parentHid = ((RfHidAccess)value).getParentHid()) instanceof RfHid)) continue;
                            checkedHids.add((RfHid)parentHid);
                        }
                    }
                }
            } else {
                for (RfHid rfHid : leftHids) {
                    checkedHids.add(rfHid);
                }
            }
            for (IHidObject iHidObject : op.getRHValues()) {
                RfHid rhHid;
                void var6_18;
                void var6_16;
                IRfNamedElement rhType = null;
                if (iHidObject instanceof RfHidAccessArgs) {
                    Hid hid = ((RfHidAccessArgs)iHidObject).getParentHid();
                }
                if (var6_16 instanceof RfHidAccess) {
                    rhType = ((RfHidAccess)var6_16).getAssociatedType();
                    if (this.checkAccessForParameters((RfHidAccess)var6_16)) {
                        continue;
                    }
                } else {
                    IRfNamedElement rhElement;
                    if (!(var6_16 instanceof RfHid) || !((rhElement = ((IHid)var6_16).getElement()) instanceof RfAssociatedType) || Check_SVTB_5_2_7.this.pSkipMethodsValue.contains(LintUtils.getNamedElementFullName((RfAssociatedType)rhElement)) || this.checkHidForParameters((RfHid)var6_16)) continue;
                    rhType = ((RfAssociatedType)rhElement).getAssociatedType();
                }
                if (rhType == null || !LintUtils.isFourStateType(rhType, Check_SVTB_5_2_7.this.pHandleTimeAsFourStateValue)) continue;
                if (var6_16 instanceof RfHidAccess) {
                    Hid hid = ((RfHidAccess)var6_16).getParentHid();
                }
                if (!(var6_18 instanceof RfHid) || checkedHids.contains((Object)(rhHid = (RfHid)var6_18))) continue;
                return false;
            }
            return true;
        }
    };

    public Check_SVTB_5_2_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected String getFailMessage() {
        return "Unchecked assignment from 4 state to 2 state type: ";
    }

    @Override
    public void performCheckImpl() {
        this.fields.clear();
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.assignmentsVisitor);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.fields != null) {
            this.fields.clear();
        }
    }
}

