/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_5_2_8;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.5.2.8")
@CheckName(value="SVTB.5.2.8")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel._4_STATE, RuleLabel.COMPARISON})
@CheckTitle(value="Comparison of 4 state types must use 4 state equivalence check")
@CheckDescription(value="The behavior of a 2 state comparison is not what a typical user expects.\nIf comparing 4 state types with 4 state types / values (or comparing 4 state types with 2 state types / values) it is recommended to use the 4 state case equality operators.\nThe use of the wildcard equality operators is also allowed - since the user is explicitly allowing for wildcards in specified bit positions.\n\nExample:\nNot Recommended:\nif (my_logic_bit == 1'b1)\nRecommended:\nif (my_logic_bit === 1'b1)\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_5_2_8.class)
public class Check_SVTB_5_2_8
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="In SystemVerilog time is a 4 state 64 bit. To avoid useless failed hits, by default this rule handles time as a 2 state type.", name="handleTimeAsFourState", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pHandleTimeAsFourStateValue;
    @CheckParameter(defaultValue="false", description="Show scope information, useful for waiving.", name="showScopeInfo", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pShowScopeInfoValue;
    @CheckParameter(defaultValue="true", description="Skip the comparison of parameter values.", name="skipParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipParametersValue;
    private DocumentManager docManager;
    private final HidOperatorVisitor comparisonVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidObject) {
            int operatorType = hidObject.getOperatorType();
            if (operatorType != 482 && operatorType != 483) {
                return true;
            }
            if (this.scope == null || !(this.scope instanceof RfNamedElement)) {
                return true;
            }
            if (Check_SVTB_5_2_8.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (Check_SVTB_5_2_8.this.isInConstraint((RfNamedElement)this.scope)) {
                return true;
            }
            Check_SVTB_5_2_8.this.notifyCheckAlive();
            HidOperator hidOperator = hidObject;
            if (hidOperator.hasOccurrence(HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION)) {
                return true;
            }
            if (this.scope instanceof RfGenerateBlock && hidOperator.hasOccurrence(HidOperatorQualifier.IS_HIDDEN)) {
                return true;
            }
            IHidObject lhHidObject = hidOperator.getLHValue();
            IRfNamedElement lhElement = null;
            if (lhHidObject instanceof RfHid) {
                lhElement = ((RfHid)lhHidObject).getElement();
            }
            IRfNamedElement rhElement = null;
            ListContainer rhValues = hidOperator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhHidObject = (IHidObject)rhValues.get(0);
            if (rhHidObject == null) {
                return true;
            }
            if (rhHidObject instanceof RfHid) {
                rhElement = ((RfHid)rhHidObject).getElement();
            }
            if (Check_SVTB_5_2_8.this.pSkipParametersValue && (lhElement != null && lhElement instanceof RfField && ((RfField)lhElement).isParameter() || rhElement != null && rhElement instanceof RfField && ((RfField)rhElement).isParameter())) {
                return true;
            }
            IRfNamedElement rhType = this.getType(rhHidObject, hidOperator, (RfNamedElement)this.scope);
            IRfNamedElement lhType = this.getType(lhHidObject, hidOperator, (RfNamedElement)this.scope);
            if (rhType != null && LintUtils.isFourStateType(rhType, Check_SVTB_5_2_8.this.pHandleTimeAsFourStateValue)) {
                IDocument document = Check_SVTB_5_2_8.this.docManager.getDocument(this.parserPath, Check_SVTB_5_2_8.this.getIProject());
                Check_SVTB_5_2_8.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), Check_SVTB_5_2_8.this.getFailMessage((RfNamedElement)this.scope, HidUtils.toNiceString((IHidObject)rhHidObject), Check_SVTB_5_2_8.this.getOffsetOnLine(document, (HidOccurrence)hidOperator.getOccurrence())), new VerissimoAutofixAdditionalInfo(hidOperator));
            } else if (lhType != null && LintUtils.isFourStateType(lhType, Check_SVTB_5_2_8.this.pHandleTimeAsFourStateValue)) {
                IDocument document = Check_SVTB_5_2_8.this.docManager.getDocument(this.parserPath, Check_SVTB_5_2_8.this.getIProject());
                Check_SVTB_5_2_8.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), Check_SVTB_5_2_8.this.getFailMessage((RfNamedElement)this.scope, HidUtils.toNiceString((IHidObject)lhHidObject), Check_SVTB_5_2_8.this.getOffsetOnLine(document, (HidOccurrence)hidOperator.getOccurrence())), new VerissimoAutofixAdditionalInfo(hidOperator));
            }
            return true;
        }

        private IRfNamedElement getType(IHidObject hidObject, HidOperator hidOperator, RfNamedElement scope) {
            IRfNamedElement result = null;
            if (hidObject instanceof RfHidAccessArgs) {
                hidObject = ((RfHidAccessArgs)hidObject).getParentHid();
            }
            if (hidObject instanceof RfHidAccess) {
                IRfNamedElement associatedType = ((RfHidAccess)hidObject).getAssociatedType();
                result = associatedType instanceof RfAssociatedType ? LintUtils.getAssociatedFinalType((RfAssociatedType)associatedType, RfTypesResolver.create(associatedType.getEnclosingScope(), Check_SVTB_5_2_8.this.fOVMProject.getRfProject(), 8)) : associatedType;
            } else if (hidObject instanceof RfHid) {
                IRfNamedElement element = ((IHid)hidObject).getElement();
                if (!(element instanceof RfAssociatedType)) {
                    return null;
                }
                result = element.getEnclosingScope() == null ? LintUtils.getAssociatedFinalType((RfAssociatedType)element) : LintUtils.getAssociatedFinalType((RfAssociatedType)element, RfTypesResolver.create(element.getEnclosingScope(), ((RfAssociatedType)element).getEnclosingScope().getRfProject(), 8));
            } else if (hidObject instanceof RfHidImplicit && ((RfHidImplicit)hidObject).isNumber() && ((RfHidImplicit)hidObject).getType() != 283) {
                String numberString = ((RfHidImplicit)hidObject).getName();
                if (numberString.toUpperCase().contains("X") || numberString.toUpperCase().contains("Z")) {
                    IDocument document = Check_SVTB_5_2_8.this.docManager.getDocument(this.parserPath, Check_SVTB_5_2_8.this.getIProject());
                    Check_SVTB_5_2_8.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), Check_SVTB_5_2_8.this.getFailMessage(scope, numberString, Check_SVTB_5_2_8.this.getOffsetOnLine(document, (HidOccurrence)hidOperator.getOccurrence())), new VerissimoAutofixAdditionalInfo(hidOperator));
                }
            } else {
                return null;
            }
            return result;
        }
    };

    public Check_SVTB_5_2_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected String getFailMessage(RfNamedElement scope, String variableName, int lineOffset) {
        String details = "";
        if (this.pShowScopeInfoValue) {
            details = " Scope: [" + LintUtils.getScopeDetails(scope.getDeclaration()) + "]";
        }
        return "2-state comparison operator used with 4-state variable at line offset " + lineOffset + ": '" + variableName + "'!" + details;
    }

    private boolean isInConstraint(RfNamedElement scope) {
        while (scope != null) {
            if (scope instanceof RfConstraint || scope instanceof RfActionBlock && ((RfActionBlock)scope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.WITH)) {
                return true;
            }
            scope = scope.getEnclosingScope();
        }
        return false;
    }

    @Override
    public void performCheckImpl() {
        this.docManager = this.getDocumentManager();
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.comparisonVisitor);
        this.docManager.deactivate();
    }

    private DocumentManager getDocumentManager() {
        DocumentManager docManager = new DocumentManager();
        try {
            docManager.activate();
        }
        catch (IllegalStateException illegalStateException) {}
        return docManager;
    }

    private int getOffsetOnLine(IDocument document, HidOccurrence occurrence) {
        int lineStartOffset = 0;
        int offsetOnLine = 0;
        try {
            lineStartOffset = document.getLineOffset(occurrence.getLine() - 1);
            offsetOnLine = occurrence.getOffset() - lineStartOffset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return offsetOnLine;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

