/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;

@CheckVersion(value="20.1.23")
@CheckID(value="SVTB.5.2.9")
@CheckName(value="SVTB.5.2.9")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel._4_STATE})
@CheckTitle(value="Do not use 4-state types")
@CheckDescription(value="Do not use 4-state types in SystemVerilog.\n\nExamples:\nlogic a; // not allowed\nreg b; // not allowed\ninteger c; // not allowed\ntime d; // not allowed\n\nNote: Arguments and return types of UVM overidden methods are not checked.\n\nCheck supports pre-waiving.")
public class Check_SVTB_5_2_9
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="logic, reg, integer, time", description="Comma separeted list of SystemVerilog 4-state types", name="fourStateTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pFourStateTypes;

    public Check_SVTB_5_2_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.accept(null, namedElement -> {
            DataType indexDataType;
            IRfNamedElement associatedType;
            DataType returnDataType;
            if (this.checkPreWaivers(namedElement.getFile())) {
                return true;
            }
            this.notifyCheckAlive();
            String elementString = LintUtils.getElementKind(namedElement);
            String elementParens = "";
            if (namedElement instanceof RfFunction) {
                elementParens = "()";
            }
            IRfNamedElement dataType = null;
            if (namedElement instanceof RfField) {
                RfField rfField = (RfField)namedElement;
                if (rfField.isGenvar() || rfField.isTypeParameter() || rfField instanceof RfCoverpoint) {
                    return true;
                }
                if (rfField.isParameterNoDataType()) {
                    return true;
                }
                dataType = LintUtils.getAssociatedFinalType((RfField)namedElement, RfTypesResolver.create((IRfScopeElement)namedElement.getEnclosingScope(), rfProject, 6));
                if (dataType == null) {
                    DataType associatedFinalDataType = rfField.getDataType();
                    String dataTypeName = associatedFinalDataType.toString();
                    List<IndexType> packedDimension = associatedFinalDataType.getPackedDimension();
                    if (packedDimension != null) {
                        for (IndexType dimension : packedDimension) {
                            if (dimension.getType() == null) continue;
                            String dimensionStringEscaped = "\\[" + dimension.getType() + "\\]";
                            dataTypeName = dataTypeName.replaceFirst(dimensionStringEscaped, "");
                        }
                    }
                    if (this.pFourStateTypes.contains(dataTypeName)) {
                        this.reportHit(namedElement, "Illegal " + dataTypeName + " " + elementString + " '" + namedElement.getFullName() + elementParens + "'!");
                        return true;
                    }
                }
            } else if (namedElement instanceof RfFunction && (returnDataType = ((RfFunction)namedElement).getDataType()) != null && this.pFourStateTypes.contains(returnDataType.getType())) {
                this.reportHit(namedElement, "Illegal " + returnDataType.getType() + " " + elementString + " '" + namedElement.getFullName() + elementParens + "'!");
                return true;
            }
            if (namedElement instanceof RfAssociatedType && (associatedType = ((RfAssociatedType)namedElement).getAssociatedType()) != null && associatedType instanceof RfListType && ((RfListType)associatedType).isAssociativeArray() && (indexDataType = ((RfListType)associatedType).getIndexTypeRaw()) != null && indexDataType.getType() != null && this.pFourStateTypes.contains(indexDataType.getType())) {
                this.reportHit(namedElement, "Illegal " + indexDataType.getType() + " associative array index for " + elementString + " '" + namedElement.getFullName() + elementParens + "'!");
                return true;
            }
            if (dataType == null) {
                return true;
            }
            if (LintUtils.isFourStateType(dataType, true)) {
                if (dataType instanceof RfStruct && ((RfStruct)dataType).isEnum()) {
                    dataType = ((RfStruct)dataType).getEnumBaseType();
                }
                if (dataType instanceof RfListType) {
                    dataType = ((RfListType)dataType).getAssociatedBaseType();
                }
                String dataTypeName = dataType.getName();
                if (dataType instanceof RfBitVectorScalarType) {
                    dataTypeName = ((RfBitVectorScalarType)dataType).getScalarWithDefaultSign().getName();
                }
                if (this.pFourStateTypes.contains(dataTypeName)) {
                    this.reportHit(namedElement, "Illegal " + dataType.getName() + " " + elementString + " '" + namedElement.getFullName() + elementParens + "'!");
                    return true;
                }
            }
            return true;
        });
    }

    private void reportHit(RfNamedElement namedElement, String message) {
        if (namedElement instanceof RfFunction && this.fOVMProject.isOVMFunctionOverride((RfFunction)namedElement)) {
            return;
        }
        if (namedElement instanceof RfField && ((RfField)namedElement).isArgument() && this.fOVMProject.isOVMFunctionOverride(namedElement.getEnclosingScope(RfFunction.class))) {
            return;
        }
        this.addHit(namedElement, message);
    }

    protected boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

