/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="17.1.38")
@CheckID(value="SVTB.5.9.8")
@CheckName(value="SVTB.5.9.8")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.ENUM, RuleLabel._4_STATE})
@CheckTitle(value="Do not use enum values containing X, Z")
@CheckDescription(value="Do not use enum values containing X, Z\n\nExamples:\nenum integer {A = 1, B = 2, C = 3} good_example; // allowed\n\nenum bit[3:0] {D = 'b0x1, E = 'z, F = 'x, G = 'b0z11} bad_example; // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_5_9_8
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, check only the enum items that are used in contraints.", name="checkOnlyEnumItemsInConstraints", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckOnlyEnumItemsInConstraints;
    Map<RfStruct, Set<String>> enumItemsWithEnum = new HashMap<RfStruct, Set<String>>();

    public Check_SVTB_5_9_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.enumItemsWithEnum.clear();
        if (!this.pCheckOnlyEnumItemsInConstraints) {
            List<RfStruct> allStructsUnionsEnums = this.fOVMProject.getRfProject().getAllStructsUnionsEnums();
            for (RfStruct struct : allStructsUnionsEnums) {
                if (!struct.isEnum()) continue;
                this.checkEnum(struct);
            }
        } else {
            for (RfNamedElement constraint : this.fOVMProject.getAllConstraints()) {
                if (this.checkPreWaivers(constraint.getFile())) continue;
                constraint.visitHidObject(null, new LocalEnumItemsVisitor());
            }
            Set<RfStruct> enums = this.enumItemsWithEnum.keySet();
            for (RfStruct enumm : enums) {
                this.checkEnum(enumm);
            }
        }
    }

    private void checkEnum(RfStruct enumm) {
        if (this.checkPreWaivers(enumm.getFile())) {
            return;
        }
        List<IHidOperator> operators = enumm.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_ASSIGN}, true);
        if (operators == null) {
            return;
        }
        this.notifyCheckAlive();
        block0: for (IHidOperator operator : operators) {
            IHidObject leftValue;
            if (!(operator instanceof RfHidOperator) || !((leftValue = operator.getLHValue()) instanceof RfHidImplicit) || this.pCheckOnlyEnumItemsInConstraints && !this.enumItemsWithEnum.get(enumm).contains(((RfHidImplicit)leftValue).getName())) continue;
            Set rightValues = operator.getRHHids(EnumSet.of(HidFlatteningOption.IGNORE_HIDS));
            for (IHid rightValue : rightValues) {
                if (!(rightValue instanceof RfHidImplicit) || !this.isInvalidValue((RfHidImplicit)rightValue)) continue;
                this.addHit(enumm.getDeclaration().getParserPath(), (HidOccurrence)operator.getOccurrence(), "Do not assign forbidden values containing 'X' or 'Z' to the enum item '" + ((RfHidImplicit)leftValue).getName() + "'!");
                continue block0;
            }
        }
    }

    private boolean isInvalidValue(RfHidImplicit rightValue) {
        if (!rightValue.isNumber()) {
            return false;
        }
        if (rightValue.getType() == 283) {
            return false;
        }
        String numberString = rightValue.getName();
        return numberString.toUpperCase().contains("X") || numberString.toUpperCase().contains("Z");
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.enumItemsWithEnum != null) {
            this.enumItemsWithEnum.clear();
        }
    }

    class LocalEnumItemsVisitor
    extends RfHidVisitor {
        LocalEnumItemsVisitor() {
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)element;
            Check_SVTB_5_9_8.this.notifyCheckAlive();
            if (!field.isEnumElement()) {
                return true;
            }
            RfStruct enclosingEnum = field.getEnclosingScope(RfStruct.class);
            if (enclosingEnum == null) {
                return true;
            }
            if (!Check_SVTB_5_9_8.this.enumItemsWithEnum.containsKey(enclosingEnum)) {
                Check_SVTB_5_9_8.this.enumItemsWithEnum.put(enclosingEnum, new HashSet());
            }
            Check_SVTB_5_9_8.this.enumItemsWithEnum.get(enclosingEnum).add(field.getName());
            return true;
        }
    }
}

