/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;

@CheckVersion(value="18.1.27")
@CheckID(value="SVTB.5.9.9")
@CheckName(value="SVTB.5.9.9")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.ENUM})
@CheckTitle(value="Do not use enum logic of 1 bit width")
@CheckDescription(value="Do not use enum logic of 1 bit width because randomization may not work in every tool.\n\nExamples:\nenum {a, b, c} good_enum; // allowed, implicit integer\n\nenum logic {d, e, f} bad_enum; // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_5_9_9
extends OVMComplianceCheck {
    private static final String LOGIC_TYPE = "logic";
    private static final String COLON_ACCESS = ":";

    public Check_SVTB_5_9_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(this.fOVMProject.getRfProject(), new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfStruct)) {
                    return true;
                }
                if (!((RfStruct)namedElement).isEnum()) {
                    return true;
                }
                Check_SVTB_5_9_9.this.notifyCheckAlive();
                if (Check_SVTB_5_9_9.this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                IRfNamedElement enumElementType = ((RfStruct)namedElement).getEnumBaseType();
                while (enumElementType instanceof RfTypeAlias) {
                    enumElementType = ((RfTypeAlias)enumElementType).getAssociatedType();
                }
                if (enumElementType instanceof RfBitVectorScalarType) {
                    String enumBaseType = enumElementType.getName();
                    if (Check_SVTB_5_9_9.LOGIC_TYPE.equals(enumBaseType)) {
                        Check_SVTB_5_9_9.this.addHit(namedElement, "Enum logic has 1 bit width!");
                    }
                    return true;
                }
                if (enumElementType instanceof RfListType) {
                    DataType enumDataType = ((RfListType)enumElementType).getDataType();
                    if (enumDataType == null) {
                        return true;
                    }
                    RfNamedElement enumBaseType = LintUtils.getAssociatedFinalType((RfListType)enumElementType);
                    if (!Check_SVTB_5_9_9.LOGIC_TYPE.equals(enumBaseType.getName())) {
                        return true;
                    }
                    if (enumDataType.getPackedDimension() == null || enumDataType.getPackedDimension().size() != 1) {
                        return true;
                    }
                    String packedDimension = enumDataType.getPackedDimension().get(0).getType();
                    if (packedDimension == null || packedDimension.isEmpty()) {
                        return true;
                    }
                    if (!packedDimension.contains(Check_SVTB_5_9_9.COLON_ACCESS)) {
                        if (packedDimension.equals("1")) {
                            Check_SVTB_5_9_9.this.addHit(namedElement, "Enum logic has 1 bit width!");
                        }
                        return true;
                    }
                    String lhs = packedDimension.substring(0, packedDimension.indexOf(Check_SVTB_5_9_9.COLON_ACCESS));
                    String rhs = packedDimension.substring(packedDimension.indexOf(Check_SVTB_5_9_9.COLON_ACCESS) + 1);
                    if (lhs == null || rhs == null) {
                        return true;
                    }
                    if (lhs.equals(rhs)) {
                        Check_SVTB_5_9_9.this.addHit(namedElement, "Enum logic has 1 bit width!");
                    }
                }
                return true;
            }
        });
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

