/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.26")
@CheckID(value="SVTB.6.10")
@CheckName(value="SVTB.6.10")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.ARRAY})
@CheckTitle(value="Always remove elements from queues, dynamic arrays and associative arrays")
@CheckDescription(value="Always remove elements from queues, dynamic arrays and associative arrays to prevent performance issues caused by very large arrays.\n\nImplementation Notes:\nThis rule checks that queues, dynamic arrays and associative arrays have one of the following methods called on them:\n[queue].delete, [queue].pop_back, [queue].pop_front, [dynamic_array].delete, [associative_array].delete,\nor they are assigned to an empty array {}, or in the case of queues, they are assigned to a queue slice expression such as: q[0:$-1] or q[1:$].\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_SVTB_6_10
extends OVMComplianceCheck {
    private static final Pattern POSITIVE_NUMBER = Pattern.compile("[1-9][0-9]*");
    private static final String ZERO_VALUE = "0";
    private static final String QUEUE_SIZE_SYMBOL = "$";
    private static final String COLON_ACCESS = ":";
    private static final String EMPTY_ARRAY_SYMBOL = "{}";
    private static final Set<String> QUEUE_REMOVE_FUNCTIONS = new HashSet<String>();
    private static final Set<String> DYNAMIC_ARRAY_REMOVE_FUNCTIONS = new HashSet<String>();
    private static final Set<String> ASSOCIATIVE_ARRAY_REMOVE_FUNCTIONS = new HashSet<String>();
    @CheckParameter(defaultValue="false", description="When true, method arguments of type queue, dynamic array or associative array will be skipped.", name="skipMethodArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipMethodArguments;
    @CheckParameter(defaultValue="false", description="When true, queues and arrays declared inside methods will be skipped.", name="skipMethodScopedElements", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipMethodScopedElements;

    static {
        QUEUE_REMOVE_FUNCTIONS.add("delete");
        QUEUE_REMOVE_FUNCTIONS.add("pop_back");
        QUEUE_REMOVE_FUNCTIONS.add("pop_front");
        DYNAMIC_ARRAY_REMOVE_FUNCTIONS.add("delete");
        ASSOCIATIVE_ARRAY_REMOVE_FUNCTIONS.add("delete");
    }

    public Check_SVTB_6_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        LocalDefVisitor visitor = new LocalDefVisitor();
        try {
            rfProject.accept(visitor);
            Set<RfNamedElement> allElements = visitor.getElements();
            if (allElements == null || allElements.isEmpty()) {
                return;
            }
            Set<RfNamedElement> validElements = this.getValidElements(rfProject, allElements);
            for (RfNamedElement elm : allElements) {
                RfNamedElement namedElement;
                if (validElements != null && validElements.contains(elm)) continue;
                RfDefElement declaration = elm.getDeclaration();
                if (this.pSkipMethodScopedElements && declaration instanceof RfDefElement && (namedElement = declaration.getNamedElement()) != null && !"argument".equals(namedElement.getKindName())) {
                    RfNamedElement enclosingScope = namedElement.getEnclosingScope();
                    while (enclosingScope != null) {
                        if (enclosingScope instanceof RfFunction) break;
                        enclosingScope = enclosingScope.getEnclosingScope();
                    }
                    if (enclosingScope instanceof RfFunction) continue;
                }
                if (elm.getFile() == null) continue;
                if (elm.getImplementation() != null) {
                    this.addHit(elm.getFile().getParserPath(), elm.getImplementation().getStartLine(), this.getHitMessage(elm), elm.getImplementation().getReparseInfo(), false);
                    continue;
                }
                if (elm.getDeclaration() == null) continue;
                this.addHit(elm.getFile().getParserPath(), elm.getDeclaration().getStartLine(), this.getHitMessage(elm), elm.getDeclaration().getReparseInfo(), false);
            }
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected Set<RfNamedElement> getValidElements(RfProject rfProject, final Set<RfNamedElement> allElements) {
        final HashSet<RfNamedElement> validElements = new HashSet<RfNamedElement>();
        rfProject.visitHidObject(rfProject, new IHidVisitor<IHidObject>(){

            public boolean visit(IHidObject hidObject) {
                switch (hidObject.getHidKind()) {
                    case HID: {
                        RfListType associatedListType;
                        RfHid hid = (RfHid)hidObject;
                        IRfNamedElement element = hid.getElement();
                        if (!(element instanceof RfPredefinedFunction)) {
                            return true;
                        }
                        Hid parentHid = hid.getParentHid();
                        if (!(parentHid instanceof RfHid)) {
                            return true;
                        }
                        IRfNamedElement parentHidElement = parentHid.getElement();
                        if (!(parentHidElement instanceof RfNamedElement)) {
                            return true;
                        }
                        if (!allElements.contains(parentHidElement)) {
                            return true;
                        }
                        Check_SVTB_6_10.this.notifyCheckAlive();
                        IRfNamedElement associatedType = Check_SVTB_6_10.this.getAssociatedType((RfNamedElement)parentHidElement);
                        String functionName = element.getName();
                        if (associatedType instanceof RfListType && ((associatedListType = (RfListType)associatedType).isQueue() && QUEUE_REMOVE_FUNCTIONS.contains(functionName) || associatedListType.isDynamicArray() && DYNAMIC_ARRAY_REMOVE_FUNCTIONS.contains(functionName) || associatedListType.isAssociativeArray() && ASSOCIATIVE_ARRAY_REMOVE_FUNCTIONS.contains(functionName))) {
                            validElements.add((RfNamedElement)parentHidElement);
                        }
                        return true;
                    }
                    case OPERATOR: {
                        RfHidOperator hidOperator = (RfHidOperator)hidObject;
                        if (!hidOperator.isAssignment()) {
                            return true;
                        }
                        IHidObject lhs = hidOperator.getLHValue();
                        if (!(lhs instanceof RfHid)) {
                            return true;
                        }
                        IRfNamedElement lhsElement = ((RfHid)lhs).getElement();
                        if (!(lhsElement instanceof RfNamedElement)) {
                            return true;
                        }
                        if (!allElements.contains(lhsElement)) {
                            return true;
                        }
                        Check_SVTB_6_10.this.notifyCheckAlive();
                        ListContainer rhs = hidOperator.getRHValues();
                        if (rhs == null || rhs.size() != 1) {
                            return true;
                        }
                        IHidObject rightValue = (IHidObject)rhs.get(0);
                        if (rightValue instanceof RfHidImplicit) {
                            String rightValueName = ((RfHidImplicit)rightValue).getName();
                            if (Check_SVTB_6_10.EMPTY_ARRAY_SYMBOL.equals(rightValueName)) {
                                validElements.add((RfNamedElement)lhsElement);
                            }
                            return true;
                        }
                        if (rightValue instanceof RfHidAccess) {
                            IRfNamedElement associatedType = Check_SVTB_6_10.this.getAssociatedType((RfNamedElement)lhsElement);
                            if (!RfListType.isQueue((IRfScopeElement)associatedType)) {
                                return true;
                            }
                            Hid rightValueParent = ((RfHidAccess)rightValue).getParentHid();
                            if (!lhs.equals(rightValueParent)) {
                                return true;
                            }
                            List selects = ((RfHidAccess)rightValue).getSelects();
                            if (selects == null || selects.size() != 1) {
                                return true;
                            }
                            IHidObject currentSelect = (IHidObject)selects.get(0);
                            if (Check_SVTB_6_10.this.checkIfRemoveOperation(currentSelect)) {
                                validElements.add((RfNamedElement)lhsElement);
                            }
                        }
                        return true;
                    }
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
        return validElements;
    }

    protected IRfNamedElement getAssociatedType(RfNamedElement element) {
        if (element == null) {
            return null;
        }
        IRfNamedElement associatedType = null;
        if (element instanceof RfField) {
            associatedType = ((RfField)element).getAssociatedType();
        } else if (element instanceof RfTypeAlias) {
            associatedType = ((RfTypeAlias)element).getAssociatedType();
        }
        while (associatedType instanceof RfTypeAlias) {
            associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
        }
        return associatedType;
    }

    private boolean checkIfRemoveOperation(IHidObject selection) {
        if (!(selection instanceof RfHidOperator)) {
            return false;
        }
        if (!((RfHidOperator)selection).getOperatorText().equals(COLON_ACCESS)) {
            return false;
        }
        IHidObject lhs = ((RfHidOperator)selection).getLHValue();
        ListContainer rhs = ((RfHidOperator)selection).getRHValues();
        if (rhs == null || rhs.size() != 1) {
            return false;
        }
        IHidObject right = (IHidObject)rhs.get(0);
        if (!(lhs instanceof RfHidImplicit)) {
            return false;
        }
        String leftValue = ((RfHidImplicit)lhs).getName();
        if (leftValue == null || leftValue.isEmpty()) {
            return false;
        }
        if (leftValue.equals(ZERO_VALUE)) {
            if (!(right instanceof RfHidOperator)) {
                return false;
            }
            RfHidOperator rightOperator = (RfHidOperator)right;
            if (!rightOperator.isMinus()) {
                return false;
            }
            IHidObject rightOperatorLHS = rightOperator.getLHValue();
            IHidObject rightOperatorRHS = (IHidObject)rightOperator.getRHValues().get(0);
            if (!(rightOperatorLHS instanceof RfHidImplicit) || !(rightOperatorRHS instanceof RfHidImplicit)) {
                return false;
            }
            if (!QUEUE_SIZE_SYMBOL.equals(((RfHidImplicit)rightOperatorLHS).getName())) {
                return false;
            }
            return POSITIVE_NUMBER.matcher(((RfHidImplicit)rightOperatorRHS).getName()).matches();
        }
        return POSITIVE_NUMBER.matcher(leftValue).matches();
    }

    protected String getHitMessage(RfNamedElement elm) {
        return "No element is removed from '" + LintUtils.getNamedElementFullName(elm) + "'!";
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class LocalDefVisitor
    implements IRfDefElementVisitor {
        private Set<RfNamedElement> elements = new HashSet<RfNamedElement>();

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return false;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            if (!(defElement instanceof RfFieldDef)) {
                return;
            }
            RfNamedElement namedElement = defElement.getNamedElement();
            if (!(namedElement instanceof RfField) && !(namedElement instanceof RfTypeAlias)) {
                return;
            }
            if (namedElement instanceof RfField && ((RfField)namedElement).isTypeParameter()) {
                return;
            }
            if (Check_SVTB_6_10.this.checkPreWaivers(defElement.getParserPath())) {
                return;
            }
            Check_SVTB_6_10.this.notifyCheckAlive();
            IRfNamedElement associatedType = Check_SVTB_6_10.this.getAssociatedType(namedElement);
            if (!RfListType.isNotFixedArray((IRfScopeElement)associatedType)) {
                return;
            }
            RfNamedElement enclosingScope = namedElement.getEnclosingScope();
            if (Check_SVTB_6_10.this.pSkipMethodArguments && enclosingScope instanceof RfFunction && "argument".equals(namedElement.getKindName())) {
                return;
            }
            if (enclosingScope instanceof RfStruct) {
                return;
            }
            this.elements.add(namedElement);
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }

        public Set<RfNamedElement> getElements() {
            return this.elements;
        }
    }
}

