/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_6_10;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.26")
@CheckID(value="SVTB.6.10.1")
@CheckName(value="SVTB.6.10.1")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.ARRAY, RuleLabel.PERFORMANCE})
@CheckTitle(value="Always read or remove elements from queues, dynamic arrays and associative arrays")
@CheckDescription(value="Always read or remove elements from queues, dynamic arrays and associative arrays because if there are only insertions and assignments, it means that the arrays are not used for anything beside storing elements.\n\nCheck supports pre-waiving.")
public class Check_SVTB_6_10_1
extends Check_SVTB_6_10 {
    private static final String EXISTS = "exists";
    private static final String EMPTY_ARRAY_SYMBOL = "{}";
    private static final Set<String> LIST_TYPE_ALLOWED_FUNCTIONS = new HashSet<String>();
    private static final Set<String> QUEUE_ALLOWED_FUNCTIONS = new HashSet<String>();
    private static final Set<String> DYNAMIC_ARRAY_ALLOWED_FUNCTIONS = new HashSet<String>();
    private static final Set<String> ASSOCIATIVE_ARRAY_ALLOWED_FUNCTIONS = new HashSet<String>();
    private static final Set<String> LIST_TYPE_NOT_ALLOWED_FUNCTIONS = new HashSet<String>();
    private static final Set<String> QUEUE_NOT_ALLOWED_FUNCTIONS = new HashSet<String>();
    private static final Set<String> DYNAMIC_ARRAY_NOT_ALLOWED_FUNCTIONS = new HashSet<String>();
    private static final Set<String> ASSOCIATIVE_ARRAY_NOT_ALLOWED_FUNCTIONS = new HashSet<String>();
    @CheckParameter(defaultValue="false", description="When true, the constructor is accepted as element removal of method argument arrays.", name="allowNewAsElementRemoval", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowNewAsElementRemoval;
    @CheckParameter(defaultValue="false", description="When true, returning an array is considered array reading.", name="allowReturnAsElementReading", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowReturnAsElementReading;
    @CheckParameter(defaultValue="false", description="When true, assignments of arrays are considered array reading.", name="allowAssignmentsAsElementReading", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowAssignmentsAsElementReading;
    @CheckParameter(defaultValue="false", description="When true, associative array exists method calls are considered array reading.", name="allowExistsAsElementReading", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowAExistsAsElementReading;
    @CheckParameter(defaultValue="true", description="When true, usage of arrays as input method arguments is considered array reading.", name="checkUsageAsInputMethodArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckUsageAsInputMethodArguments;

    static {
        LIST_TYPE_ALLOWED_FUNCTIONS.add("find");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("find_first");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("find_last");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("find_index");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("find_first_index");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("find_last_index");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("max");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("min");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("unique");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("unique_index");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("sum");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("product");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("and");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("or");
        LIST_TYPE_ALLOWED_FUNCTIONS.add("xor");
        QUEUE_ALLOWED_FUNCTIONS.addAll(LIST_TYPE_ALLOWED_FUNCTIONS);
        QUEUE_ALLOWED_FUNCTIONS.add("delete");
        QUEUE_ALLOWED_FUNCTIONS.add("pop_back");
        QUEUE_ALLOWED_FUNCTIONS.add("pop_front");
        QUEUE_ALLOWED_FUNCTIONS.add("pick");
        DYNAMIC_ARRAY_ALLOWED_FUNCTIONS.addAll(LIST_TYPE_ALLOWED_FUNCTIONS);
        DYNAMIC_ARRAY_ALLOWED_FUNCTIONS.add("delete");
        ASSOCIATIVE_ARRAY_ALLOWED_FUNCTIONS.addAll(LIST_TYPE_ALLOWED_FUNCTIONS);
        ASSOCIATIVE_ARRAY_ALLOWED_FUNCTIONS.add("delete");
        LIST_TYPE_NOT_ALLOWED_FUNCTIONS.add("reverse");
        LIST_TYPE_NOT_ALLOWED_FUNCTIONS.add("sort");
        LIST_TYPE_NOT_ALLOWED_FUNCTIONS.add("rsort");
        LIST_TYPE_NOT_ALLOWED_FUNCTIONS.add("shuffle");
        QUEUE_NOT_ALLOWED_FUNCTIONS.addAll(LIST_TYPE_NOT_ALLOWED_FUNCTIONS);
        QUEUE_NOT_ALLOWED_FUNCTIONS.add("size");
        QUEUE_NOT_ALLOWED_FUNCTIONS.add("insert");
        QUEUE_NOT_ALLOWED_FUNCTIONS.add("push_front");
        QUEUE_NOT_ALLOWED_FUNCTIONS.add("push_back");
        QUEUE_NOT_ALLOWED_FUNCTIONS.add("empty");
        DYNAMIC_ARRAY_NOT_ALLOWED_FUNCTIONS.addAll(LIST_TYPE_NOT_ALLOWED_FUNCTIONS);
        DYNAMIC_ARRAY_NOT_ALLOWED_FUNCTIONS.add("new");
        DYNAMIC_ARRAY_NOT_ALLOWED_FUNCTIONS.add("size");
        ASSOCIATIVE_ARRAY_ALLOWED_FUNCTIONS.addAll(LIST_TYPE_NOT_ALLOWED_FUNCTIONS);
        ASSOCIATIVE_ARRAY_NOT_ALLOWED_FUNCTIONS.add("num");
        ASSOCIATIVE_ARRAY_NOT_ALLOWED_FUNCTIONS.add("size");
        ASSOCIATIVE_ARRAY_NOT_ALLOWED_FUNCTIONS.add(EXISTS);
        ASSOCIATIVE_ARRAY_NOT_ALLOWED_FUNCTIONS.add("first");
        ASSOCIATIVE_ARRAY_NOT_ALLOWED_FUNCTIONS.add("last");
        ASSOCIATIVE_ARRAY_NOT_ALLOWED_FUNCTIONS.add("next");
        ASSOCIATIVE_ARRAY_NOT_ALLOWED_FUNCTIONS.add("prev");
    }

    public Check_SVTB_6_10_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
    }

    @Override
    protected Set<RfNamedElement> getValidElements(RfProject rfProject, final Set<RfNamedElement> allElements) {
        final HashSet<RfNamedElement> validElements = new HashSet<RfNamedElement>();
        rfProject.visitHidObject(rfProject, new IHidVisitor<IHidObject>(){

            public boolean visit(IHidObject hidObject) {
                if (hidObject instanceof RfHid) {
                    String functionName;
                    boolean bl;
                    RfHid hid = (RfHid)hidObject;
                    IRfNamedElement element = hid.getElement();
                    if (Check_SVTB_6_10_1.this.pCheckUsageAsInputMethodArguments && element instanceof RfFunction) {
                        List list = MethodCallUtils.getMethodCalls((IHid)hid);
                        for (MethodCall call : list) {
                            if (call.argumentValuesMap == null || call.argumentValuesMap.isEmpty()) continue;
                            for (Map.Entry entry : call.argumentValuesMap.entrySet()) {
                                RfField argument;
                                IRfNamedElement key = (IRfNamedElement)entry.getKey();
                                if (!(key instanceof RfField) || !(argument = (RfField)key).isInout() && !argument.isInput() && !argument.isConstRef() && !argument.isRef()) continue;
                                Set values = (Set)entry.getValue();
                                for (IHid value : values) {
                                    RfField field;
                                    IRfNamedElement associatedType;
                                    if (!(value instanceof RfHid) || !(value.getElement() instanceof RfField) || !RfListType.isNotFixedArray((IRfScopeElement)(associatedType = Check_SVTB_6_10_1.this.getAssociatedType(field = (RfField)value.getElement())))) continue;
                                    validElements.add(field);
                                }
                            }
                        }
                    }
                    boolean bl2 = bl = hid.getParentAccess() != null && hid.getParentAccess().isSelect();
                    if (!bl && !(element instanceof RfPredefinedFunction) || bl && !(element instanceof RfFunction) && !(element instanceof RfField)) {
                        return true;
                    }
                    if (bl && !(hid.getParentAccess().getAssociatedType() instanceof RfClass)) {
                        return true;
                    }
                    Hid parentHid = hid.getParentHid();
                    if (!(parentHid instanceof RfHid)) {
                        return true;
                    }
                    IRfNamedElement parentHidElement = parentHid.getElement();
                    if (!(parentHidElement instanceof RfNamedElement)) {
                        return true;
                    }
                    if (!allElements.contains(parentHidElement)) {
                        return true;
                    }
                    IRfNamedElement associatedType = Check_SVTB_6_10_1.this.getAssociatedType((RfNamedElement)parentHidElement);
                    if (this.isValidFunctionForType(associatedType, functionName = element.getName(), bl)) {
                        validElements.add((RfNamedElement)parentHidElement);
                    }
                    return true;
                }
                if (hidObject instanceof RfHidOperator) {
                    ListContainer rhs;
                    RfHidOperator hidOperator = (RfHidOperator)hidObject;
                    boolean checkOnlyRHS = false;
                    boolean bl = hidOperator.isInside();
                    boolean isAssignment = hidOperator.isAssignment();
                    boolean isConcatenation = hidOperator.isStreamConcatenation();
                    if ((isAssignment || bl || isConcatenation) && (rhs = hidOperator.getRHValues()) != null && rhs.size() == 1) {
                        IHidObject rightValue = (IHidObject)rhs.get(0);
                        String rightValueName = "";
                        if (rightValue instanceof RfHidImplicit) {
                            rightValueName = ((RfHidImplicit)rightValue).getName();
                        } else if (rightValue instanceof RfHid) {
                            rightValueName = ((RfHid)rightValue).getName();
                        }
                        if (!Check_SVTB_6_10_1.EMPTY_ARRAY_SYMBOL.equals(rightValueName)) {
                            checkOnlyRHS = true;
                        }
                    }
                    Check_SVTB_6_10_1.this.checkOperator(hidOperator, checkOnlyRHS, isAssignment, bl, isConcatenation, validElements, allElements);
                    return true;
                }
                if (hidObject instanceof RfHidAccessArgs) {
                    RfHidAccessArgs hidAccessArgs = (RfHidAccessArgs)hidObject;
                    List<? extends IHidObject> argumentValues = hidAccessArgs.getArgumentValues();
                    if (argumentValues == null || argumentValues.isEmpty()) {
                        return true;
                    }
                    for (IHidObject iHidObject : argumentValues) {
                        if (!(iHidObject instanceof RfHidOperator)) continue;
                        Check_SVTB_6_10_1.this.checkOperator((RfHidOperator)iHidObject, true, false, false, ((RfHidOperator)iHidObject).isAssignment(), validElements, allElements);
                    }
                    return true;
                }
                return true;
            }

            private boolean isValidFunctionForType(IRfNamedElement associatedType, String functionName, boolean isSelect) {
                if (!(associatedType instanceof RfListType)) {
                    return false;
                }
                RfListType associatedListType = (RfListType)associatedType;
                if (isSelect) {
                    return associatedListType.isDynamicArray() || associatedListType.isQueue() || associatedListType.isAssociativeArray();
                }
                return associatedListType.isDynamicArray() && DYNAMIC_ARRAY_ALLOWED_FUNCTIONS.contains(functionName) || associatedListType.isQueue() && QUEUE_ALLOWED_FUNCTIONS.contains(functionName) || associatedListType.isAssociativeArray() && ASSOCIATIVE_ARRAY_ALLOWED_FUNCTIONS.contains(functionName);
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
        return validElements;
    }

    private void checkOperator(RfHidOperator operator, boolean checkOnlyRHS, boolean isAssignment, boolean isInside, boolean isConcatenation, Set<RfNamedElement> validElements, Set<RfNamedElement> allElements) {
        IHidObject lhs = operator.getLHValue();
        ListContainer rhs = operator.getRHValues();
        if (!checkOnlyRHS) {
            this.checkIfValidElement(lhs, validElements, allElements, isAssignment, false, isConcatenation);
        }
        if (rhs == null || rhs.isEmpty()) {
            return;
        }
        for (IHidObject rhsElement : rhs) {
            this.checkIfValidElement(rhsElement, validElements, allElements, false, isInside, isConcatenation);
        }
        if (this.pAllowReturnAsElementReading && operator.isReturnStatement() || this.pAllowAssignmentsAsElementReading && isAssignment) {
            IHidObject rhsHid = (IHidObject)rhs.get(0);
            if (!(rhsHid instanceof RfHid)) {
                return;
            }
            IRfNamedElement returnElement = ((RfHid)rhsHid).getElement();
            if (!(returnElement instanceof RfNamedElement)) {
                return;
            }
            validElements.add((RfNamedElement)returnElement);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkIfValidElement(IHidObject elm, Set<RfNamedElement> validElements, Set<RfNamedElement> allElements, boolean isAssignmentLHS, boolean isInside, boolean isConcatenation) {
        block40: {
            block37: {
                block39: {
                    block38: {
                        if (!(elm instanceof RfHid)) break block37;
                        hidElement = ((RfHid)elm).getElement();
                        if (!(hidElement instanceof RfNamedElement)) {
                            return;
                        }
                        validElement = null;
                        if (!allElements.contains(hidElement) || !isAssignmentLHS && !isInside && !isConcatenation) break block38;
                        validElement = hidElement;
                        break block39;
                    }
                    if (isAssignmentLHS) break block39;
                    parentAccess = ((RfHid)elm).getParentAccess();
                    parentHid = ((RfHid)elm).getParentHid();
                    if (parentAccess == null || parentHid == null) {
                        return;
                    }
                    if (parentAccess.getSelects() != null) ** GOTO lbl35
                    parentHidElement = parentHid.getElement();
                    if (!allElements.contains(parentHidElement)) {
                        return;
                    }
                    associatedType = this.getAssociatedType((RfNamedElement)parentHidElement);
                    functionName = hidElement.getName();
                    if (!(associatedType instanceof RfListType)) break block39;
                    associatedListType = (RfListType)associatedType;
                    if (associatedListType.isQueue() != false && Check_SVTB_6_10_1.QUEUE_NOT_ALLOWED_FUNCTIONS.contains(functionName) != false || associatedListType.isDynamicArray() != false && Check_SVTB_6_10_1.DYNAMIC_ARRAY_NOT_ALLOWED_FUNCTIONS.contains(functionName) != false || associatedListType.isAssociativeArray() && Check_SVTB_6_10_1.ASSOCIATIVE_ARRAY_NOT_ALLOWED_FUNCTIONS.contains(functionName)) {
                        return;
                    }
                    if (!(associatedListType.isQueue() != false && Check_SVTB_6_10_1.QUEUE_ALLOWED_FUNCTIONS.contains(functionName) != false || associatedListType.isDynamicArray() != false && Check_SVTB_6_10_1.DYNAMIC_ARRAY_ALLOWED_FUNCTIONS.contains(functionName) != false) && (!associatedListType.isAssociativeArray() || !Check_SVTB_6_10_1.ASSOCIATIVE_ARRAY_ALLOWED_FUNCTIONS.contains(functionName))) break block39;
                    validElements.add((RfNamedElement)parentHidElement);
                    break block39;
lbl-1000:
                    // 1 sources

                    {
                        parentHidElement = parentHid.getElement();
                        if (allElements.contains(parentHidElement)) {
                            validElement = parentHidElement;
                            break;
                        }
                        parentAccess = parentHid.getParentAccess();
                        parentHid = parentHid.getParentHid();
lbl35:
                        // 2 sources

                        ** while (parentAccess != null && parentHid != null)
                    }
                }
                if (validElement == null) {
                    return;
                }
                validElements.add((RfNamedElement)validElement);
                return;
            }
            if (elm instanceof RfHidOperator) {
                if (isAssignmentLHS) {
                    return;
                }
                lhs = ((RfHidOperator)elm).getLHValue();
                rhs = ((RfHidOperator)elm).getRHValues();
                this.checkIfValidElement(lhs, validElements, allElements, false, isInside, isConcatenation);
                if (rhs == null || rhs.isEmpty()) {
                    return;
                }
                for (IHidObject rhsElement : rhs) {
                    this.checkIfValidElement(rhsElement, validElements, allElements, false, isInside, isConcatenation);
                }
                return;
            }
            if (!(elm instanceof RfHidAccess)) break block40;
            if (isAssignmentLHS) {
                return;
            }
            parentHid = ((RfHidAccess)elm).getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return;
            }
            parentHidElement = parentHid.getElement();
            if (!(parentHidElement instanceof RfNamedElement)) {
                return;
            }
            validElement = null;
            if (!(elm instanceof RfHidAccessArgs)) ** GOTO lbl98
            if (this.pAllowNewAsElementRemoval) {
                if (!(parentHidElement instanceof RfPredefinedFunction)) {
                    return;
                }
                if (!((RfPredefinedFunction)parentHidElement).isConstructor()) {
                    return;
                }
                parrentAccess = parentHid.getParentAccess();
                if (!(parrentAccess instanceof RfHidAccess)) {
                    return;
                }
                elementHid = parrentAccess.getParentHid();
                if (elementHid == null) {
                    return;
                }
                newElemenet = elementHid.getElement();
                if (!(newElemenet instanceof RfField)) {
                    return;
                }
                newField = (RfField)newElemenet;
                if (!newField.isArgument()) {
                    return;
                }
                validElement = newField;
            } else if (this.pAllowAExistsAsElementReading) {
                if (!(parentHidElement instanceof RfPredefinedFunction)) {
                    return;
                }
                if (parentHidElement.getName().equals("exists")) {
                    functionParentAccess = parentHid.getParentAccess();
                    if (functionParentAccess == null) {
                        return;
                    }
                    callerHid = functionParentAccess.getParentHid();
                    if (callerHid == null) {
                        return;
                    }
                    validElement = callerHid.getElement();
                }
            } else {
                return;
lbl98:
                // 1 sources

                if (allElements.contains(parentHidElement)) {
                    validElement = parentHidElement;
                } else {
                    parentAccess = parentHid.getParentAccess();
                    parent = parentHid.getParentHid();
                    while (parentAccess != null && parent != null) {
                        parentElement = parent.getElement();
                        if (allElements.contains(parentElement)) {
                            validElement = parentElement;
                            break;
                        }
                        parentAccess = parent.getParentAccess();
                        parent = parent.getParentHid();
                    }
                }
            }
            if (validElement == null) {
                return;
            }
            validElements.add((RfNamedElement)validElement);
            return;
        }
    }

    @Override
    protected String getHitMessage(RfNamedElement elm) {
        return "No element is removed or read from '" + LintUtils.getNamedElementFullName(elm) + "'!";
    }
}

