/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="19.1.48")
@CheckID(value="SVTB.6.11")
@CheckName(value="SVTB.6.11")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.PARAMETER, RuleLabel.BIND})
@CheckTitle(value="Bind parameters by name when using parameterized types")
@CheckDescription(value="The parameters should be passed by name when their number is greater than 'checkIffNofParametersGreaterThan'.")
@CheckReapplyDisable
public class Check_SVTB_6_11
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="3", description="Check only parameterized types with more than nof parameters.", name="checkIffNofParametersGreaterThan", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    Integer pCheckIffNofParametersGreaterThanValue;
    private static final Set<String> UVM_REGISTRY_NAMES = Sets.newHashSet((Object[])new String[]{"uvm_component_registry", "uvm_object_registry", "uvm_abstract_component_registry", "uvm_abstract_object_registry"});

    public Check_SVTB_6_11(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(null, new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (namedElement == null) {
                    return true;
                }
                if (namedElement.isPredefined()) {
                    return true;
                }
                if (namedElement instanceof RfLibrary) {
                    return true;
                }
                if (namedElement instanceof RfResultImplicitVariable) {
                    return true;
                }
                Check_SVTB_6_11.this.notifyCheckAlive();
                if (namedElement instanceof RfField || namedElement instanceof RfTypeAlias) {
                    this.handleElementWithDataType((RfAssociatedType)namedElement, namedElement.getDeclaration().getReparseInfo());
                }
                if (namedElement instanceof RfClass) {
                    this.handleClass((RfClass)namedElement, namedElement.getDeclaration().getReparseInfo());
                }
                return true;
            }

            private void handleClass(RfClass element, ReparseInfo reparseInfo) {
                RfClass parent = element.getParent();
                if (parent == null) {
                    return;
                }
                DataType dataType = element.getExtendedType();
                this.handleDataType(element, dataType, reparseInfo);
            }

            private void handleElementWithDataType(RfAssociatedType element, ReparseInfo reparseInfo) {
                DataType dataType = element.getDataType();
                this.handleDataType(element, dataType, reparseInfo);
            }

            private void handleDataType(RfNamedElement element, DataType dataType, ReparseInfo reparseInfo) {
                if (dataType == null) {
                    return;
                }
                RfDefElement declaration = element.getDeclaration();
                if (declaration == null) {
                    return;
                }
                ParserPath parserPath = declaration.getParserPath();
                if (parserPath == null) {
                    return;
                }
                this.handleDataTypeHelper(parserPath, dataType, reparseInfo);
            }

            private void handleDataTypeHelper(ParserPath parserPath, DataType dataType, ReparseInfo reparseInfo) {
                Map<String, ArgInfo> namedParamAssignments;
                if (dataType == null) {
                    return;
                }
                List<DataType> orderedParamAssignments = dataType.getOrderedParamAssignments();
                if (orderedParamAssignments != null) {
                    if (!(orderedParamAssignments.size() <= Check_SVTB_6_11.this.pCheckIffNofParametersGreaterThanValue || UVM_REGISTRY_NAMES.contains(dataType.getType()) && reparseInfo != null && "uvm_object_defines.svh".equals(LintUtils.getFileShortName(reparseInfo.getLastReparseElement().getReparseMacroFile().path)))) {
                        Check_SVTB_6_11.this.addHit(parserPath, dataType.getLine(), this.getHitMessage(dataType), null);
                    }
                    for (DataType newDataType : orderedParamAssignments) {
                        this.handleDataTypeHelper(parserPath, newDataType, reparseInfo);
                    }
                }
                if ((namedParamAssignments = dataType.getNamedParamAssignments()) != null) {
                    for (Map.Entry<String, ArgInfo> entry : namedParamAssignments.entrySet()) {
                        DataType newDataType = entry.getValue().getDataType();
                        this.handleDataTypeHelper(parserPath, newDataType, reparseInfo);
                    }
                }
            }

            private String getHitMessage(DataType dataType) {
                String type = dataType.getType();
                if (type == null || type.isEmpty()) {
                    return "Data type should have parameters bound by name!";
                }
                return "'" + type + "' should have parameters bound by name!";
            }
        });
    }
}

