/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="20.1.29")
@CheckID(value="SVTB.6.12")
@CheckName(value="SVTB.6.12")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.RANGE, RuleLabel.ARRAY})
@CheckTitle(value="Do not declare bounded queues")
@CheckDescription(value="This rule checks there are no bounded queues declared.\nAdding elements to a bounded queue beyond the bound will result in the elements being discarded and a warning being issued.\nIf a bound is really necessary, it can be enforced by actually checking the size of the queue before adding to it.\n\nExamples:\nint my_unbounded_queue[$]; // allowed\nint my_bounded_queue[$:10]; // not allowed\nint my_bounded_queue_2[$:5]; // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_6_12
extends OVMComplianceCheck {
    public Check_SVTB_6_12(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        IRfNamedElementVisitor queueVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (namedElement == null) {
                    return true;
                }
                if (namedElement.getFile() == null) {
                    return true;
                }
                ParserPath parserPath = namedElement.getFile().getParserPath();
                if (Check_SVTB_6_12.this.checkPreWaivers(parserPath)) {
                    return true;
                }
                Check_SVTB_6_12.this.notifyCheckAlive();
                if (namedElement instanceof RfField) {
                    RfField field = (RfField)namedElement;
                    IRfNamedElement fieldType = field.getAssociatedType();
                    while (fieldType instanceof RfTypeAlias) {
                        fieldType = ((RfTypeAlias)fieldType).getAssociatedType();
                    }
                    if (RfListType.isBoundQueue((IRfScopeElement)fieldType)) {
                        Check_SVTB_6_12.this.addHit(namedElement, "The " + LintUtils.getElementKind(field) + " '" + LintUtils.getNamedElementFullName(field) + "' should be an unbounded queue!");
                    }
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().accept(queueVisitor);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

