/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.6.1.2.1")
@CheckName(value="SVTB.6.1.2.1")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.STRUCT})
@CheckTitle(value="Packed struct members must be bit or logic")
@CheckDescription(value="When using packed struct the members must be bit types.\nThis prevents common mistakes of using integer types that are too large and mixed signed/unsigned types within the struct.\n\nExamples:\ntypedef struct packed {\n\treal f; // not allowed\n\tint i; // not allowed\n\tbit x; // allowed\n} my_struct;\n\nCheck supports pre-waiving.")
public class Check_SVTB_6_1_2_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="When true, members can be fixed width enum types.", name="allowFixedWidthEnums", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowFixedWidthEnumsValue;
    @CheckParameter(defaultValue="false", description="When true, members can be unsigned types (unsigned byte, unsigned shortint, unsigned int, unsigned longint, unsigned integer, unsigned time).", name="allowUnsignedTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowUnsignedTypesValue;

    public Check_SVTB_6_1_2_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct struct : this.fOVMProject.getAllStructs()) {
            if (!struct.isPacked() || this.checkPreWaivers(struct.getFile())) continue;
            this.checkStruct(struct);
        }
    }

    private boolean checkStruct(RfStruct struct) {
        boolean anyFailure = false;
        this.notifyCheckAlive();
        List<RfField> fields = struct.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null || fields.isEmpty()) {
            return anyFailure;
        }
        for (RfField field : fields) {
            RfNamedElement fieldType = LintUtils.getAssociatedFinalType(field);
            if (fieldType == null) {
                this.addHit(field, "Unknown struct member type '" + field.getName() + "'.");
                anyFailure = true;
                continue;
            }
            if (fieldType instanceof RfStruct) {
                RfStruct structType = (RfStruct)fieldType;
                if (this.pAllowFixedWidthEnumsValue && structType.isEnum()) {
                    anyFailure |= this.checkEnum(structType, field);
                    continue;
                }
                if (structType.isPacked()) {
                    String fullTypeName = fieldType.getFullName();
                    if (structType.isEnum()) {
                        this.addHit(field, "Not allowed packed struct member '" + field.getName() + "' of type 'enum'.");
                        anyFailure = true;
                        continue;
                    }
                    if (!this.checkStruct(structType)) continue;
                    if (structType.isEnum()) {
                        fullTypeName = "enum";
                    }
                    if (structType.isStruct()) {
                        fullTypeName = "struct";
                    }
                    this.addHit(field, "Not allowed packed struct member '" + field.getName() + "' of type '" + fullTypeName + "'.");
                    anyFailure = true;
                    continue;
                }
            }
            if (this.isValidField(fieldType)) continue;
            String fullTypeName = fieldType.getFullName();
            if (fieldType instanceof RfStruct && ((RfStruct)fieldType).isEnum()) {
                fullTypeName = "enum";
            }
            if (fieldType instanceof RfStruct && ((RfStruct)fieldType).isStruct()) {
                fullTypeName = "struct";
            }
            this.addHit(field, "Not allowed packed struct member '" + field.getName() + "' of type '" + fullTypeName + "'.");
            anyFailure = true;
        }
        return anyFailure;
    }

    private boolean isValidField(RfNamedElement associatedType) {
        if (!(associatedType instanceof RfBitVectorScalarType)) {
            return false;
        }
        if (((RfBitVectorScalarType)associatedType).getBitSize() == 1) {
            return true;
        }
        return this.pAllowUnsignedTypesValue && ((RfBitVectorScalarType)associatedType).getSign() == 2;
    }

    private boolean checkEnum(RfStruct enums, RfField enumsElement) {
        boolean anyFailure = false;
        IRfNamedElement enumBaseType = enums.getEnumBaseType();
        if (enumBaseType == null) {
            this.addHit(enumsElement, "Unknown enum type.");
            anyFailure = true;
            return anyFailure;
        }
        if (enumBaseType instanceof RfListType) {
            enumBaseType = ((RfListType)enumBaseType).getAssociatedBaseType();
        }
        if (enumBaseType instanceof RfStruct && (((RfStruct)enumBaseType).isPacked() || ((RfStruct)enumBaseType).isEnum())) {
            anyFailure = ((RfStruct)enumBaseType).isEnum() ? (anyFailure |= this.checkEnum((RfStruct)enumBaseType, enumsElement)) : (anyFailure |= this.checkStruct((RfStruct)enumBaseType));
            return anyFailure;
        }
        if (!(enumBaseType instanceof RfNamedElement)) {
            return anyFailure;
        }
        if (!(enumBaseType instanceof RfBitVectorScalarType) || ((RfBitVectorScalarType)enumBaseType).getBitSize() != 1) {
            this.addHit(enumsElement, "Not allowed enum '" + enumsElement.getName() + "' of type '" + ((RfNamedElement)enumBaseType).getFullName() + "', only fixed width enums are allowed.");
            anyFailure = true;
        }
        return anyFailure;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

