/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;

@CheckVersion(value="18.1.21")
@CheckID(value="SVTB.6.1.2.2")
@CheckName(value="SVTB.6.1.2.2")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.STRUCT, RuleLabel._4_STATE})
@CheckTitle(value="Packed struct members must be similar (signed/unsigned, 2-state/4-state)")
@CheckDescription(value="When using packed struct, the members must be have similar types. \nDo not mix signed with unsigned members or 2-state with 4-state members.\n\nExamples:\ntypedef struct packed { // not allowed, integer is signed and the others members are unsigned\n\tlogic l;\n\treg r;\n\tinteger intger;\n\ttime t;\n} my_bad_struct;\n\ntypedef struct packed { // allowed\n\tlogic l;\n\treg r;\n\ttime t;\n} my_good_struct;\n\nCheck supports pre-waiving.")
public class Check_SVTB_6_1_2_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="When true, checks the mix of 2-state and 4-state members.", name="check2State4StateTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheck2State4StateTypes;
    @CheckParameter(defaultValue="true", description="When true, checks the mix of signed and unsigned members.", name="checkSignedUnsignedTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckSignedUnsignedTypes;

    public Check_SVTB_6_1_2_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct struct : this.fOVMProject.getAllStructs()) {
            if (!struct.isPacked()) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(struct.getFile())) continue;
            HashMap<String, RfNamedElement> fourStateDataTypes = new HashMap<String, RfNamedElement>();
            HashMap<String, RfNamedElement> twoStateDataTypes = new HashMap<String, RfNamedElement>();
            HashMap<String, RfNamedElement> signedDataTypes = new HashMap<String, RfNamedElement>();
            HashMap<String, RfNamedElement> unsignedDataTypes = new HashMap<String, RfNamedElement>();
            this.checkStruct(struct, struct.getAliasName() == null ? "struct" : struct.getAliasName(), fourStateDataTypes, twoStateDataTypes, signedDataTypes, unsignedDataTypes);
            if (this.pCheck2State4StateTypes) {
                this.checkCategoriesForStruct(struct, fourStateDataTypes, twoStateDataTypes, "Packed struct contains mixed 2-state / 4-state members:\n", "2-state members: \n", "4-state members: \n");
            }
            if (!this.pCheckSignedUnsignedTypes) continue;
            this.checkCategoriesForStruct(struct, signedDataTypes, unsignedDataTypes, "Packed struct contains mixed signed / unsigned members:\n", "Unsigned members: \n", "Signed members: \n");
        }
    }

    private void checkStruct(RfStruct struct, String fullyQualifiedFieldName, Map<String, RfNamedElement> fourStateDataTypes, Map<String, RfNamedElement> twoStateDataTypes, Map<String, RfNamedElement> signedDataTypes, Map<String, RfNamedElement> unsignedDataTypes) {
        List<RfField> fields = struct.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null || fields.isEmpty()) {
            return;
        }
        for (RfField field : fields) {
            RfNamedElement fieldType;
            DataType dataType;
            LintUtils.FullTypeData associatedFinalDataType = LintUtils.getAssociatedFinalDataType(field);
            if (associatedFinalDataType == null || (dataType = associatedFinalDataType.getAssocDataType()) == null || (fieldType = (RfNamedElement)associatedFinalDataType.getAssocType()) == null) continue;
            if (fieldType instanceof RfStruct && ((RfStruct)fieldType).isEnum()) {
                IRfNamedElement enumBaseType = ((RfStruct)fieldType).getEnumBaseType();
                if (!(enumBaseType instanceof RfNamedElement)) continue;
                this.checkTypes(String.valueOf(fullyQualifiedFieldName) + "." + LintUtils.getNamedElementFullName(field), (RfNamedElement)enumBaseType, dataType, fourStateDataTypes, twoStateDataTypes, signedDataTypes, unsignedDataTypes);
                continue;
            }
            if (fieldType instanceof RfStruct && ((RfStruct)fieldType).isPacked()) {
                this.checkStruct((RfStruct)fieldType, String.valueOf(fullyQualifiedFieldName) + "." + LintUtils.getNamedElementFullName(field), fourStateDataTypes, twoStateDataTypes, signedDataTypes, unsignedDataTypes);
                continue;
            }
            if (!(fieldType instanceof RfBitVectorScalarType)) continue;
            this.checkTypes(String.valueOf(fullyQualifiedFieldName) + "." + LintUtils.getNamedElementFullName(field), fieldType, dataType, fourStateDataTypes, twoStateDataTypes, signedDataTypes, unsignedDataTypes);
        }
    }

    private void checkTypes(String fullyQualifiedName, RfNamedElement fieldType, DataType dataType, Map<String, RfNamedElement> fourStateDataTypes, Map<String, RfNamedElement> twoStateDataTypes, Map<String, RfNamedElement> signedDataTypes, Map<String, RfNamedElement> unsignedDataTypes) {
        if (LintUtils.isFourStateType(fieldType, true)) {
            fourStateDataTypes.put(fullyQualifiedName, fieldType);
        } else {
            twoStateDataTypes.put(fullyQualifiedName, fieldType);
        }
        if (dataType.getSign() == 1 || dataType.getSign() == 0 && LintUtilsConstants.INTEGER_SIGNED_TYPES.contains(fieldType.getName())) {
            signedDataTypes.put(fullyQualifiedName, fieldType);
        } else if (dataType.getSign() == 2 || dataType.getSign() == 0 && LintUtilsConstants.INTEGER_UNSIGNED_TYPES.contains(fieldType.getName())) {
            unsignedDataTypes.put(fullyQualifiedName, fieldType);
        }
    }

    private void checkCategoriesForStruct(RfStruct struct, Map<String, RfNamedElement> firstCategoryOfTypes, Map<String, RfNamedElement> secondCategoryOfTypes, String title, String firstCategory, String secondCategory) {
        if (firstCategoryOfTypes.size() == 0 || secondCategoryOfTypes.size() == 0) {
            return;
        }
        StringBuilder hitMessage = new StringBuilder();
        hitMessage.append(title);
        hitMessage.append(firstCategory);
        for (Map.Entry<String, RfNamedElement> entry : secondCategoryOfTypes.entrySet()) {
            hitMessage.append("\t'").append(entry.getKey()).append("' of type '").append(this.getfullTypeName(entry.getValue())).append("'\n");
        }
        hitMessage.append(secondCategory);
        for (Map.Entry<String, RfNamedElement> entry : firstCategoryOfTypes.entrySet()) {
            hitMessage.append("\t'").append(entry.getKey()).append("' of type '").append(this.getfullTypeName(entry.getValue())).append("'\n");
        }
        this.addHit(struct, hitMessage.toString());
    }

    private String getfullTypeName(RfNamedElement fieldType) {
        String fullTypeName = fieldType.getFullName();
        if (fieldType instanceof RfStruct && ((RfStruct)fieldType).isEnum()) {
            fullTypeName = "enum";
        }
        if (fieldType instanceof RfStruct && ((RfStruct)fieldType).isStruct()) {
            fullTypeName = "struct";
        }
        return fullTypeName;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

