/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractRangeArrayCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.3")
@CheckID(value="SVTB.6.3.3")
@CheckName(value="SVTB.6.3.3")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.RANGE, RuleLabel.ARRAY})
@CheckTitle(value="Declare unpacked array size with sizes rather than ranges")
@CheckDescription(value="Specifying the range has unexpected effects when iterating the array.\n\nExample:\nint myarray [8];\ninstead of:\nint myarray[0:7]\n\nCheck supports pre-waiving.")
public class Check_SVTB_6_3_3
extends AbstractRangeArrayCheck {
    public Check_SVTB_6_3_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected List<IndexType> getDimensions(DataType datatype) {
        return datatype.getUnpackedDimension();
    }

    @Override
    protected void addHitCheck(IHidObject rangeObj, RfNamedElement namedElement) {
        if (((RfHidOperator)rangeObj).isRangeOrPartSelect()) {
            this.addHit(namedElement, "Variable '" + LintUtils.getNamedElementFullName(namedElement) + "' was declared with ranges instead of size!");
        }
    }
}

