/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractStaticCastToStringCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.6.5.1.1")
@CheckName(value="SVTB.6.5.1.1")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.STRING, RuleLabel.CAST})
@CheckTitle(value="Do not cast to string")
@CheckDescription(value="Try using either one of the 'to' methods (like itoa()) or using the $sprint or $sformat system calls.\n\nCheck supports pre-waiving.")
public class Check_SVTB_6_5_1_1
extends AbstractStaticCastToStringCheck {
    public Check_SVTB_6_5_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getFailMessage() {
        return "Not allowed cast to string!";
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (Check_SVTB_6_5_1_1.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                Check_SVTB_6_5_1_1.this.notifyCheckAlive();
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                if (!(hidObject.getElement() instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)hidObject.getElement();
                if (!"$cast".equals(function.getName())) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                Hid destArgumentValue = null;
                for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMapRaw == null) continue;
                    for (Map.Entry argument : methodCall.argumentValuesMapRaw.entrySet()) {
                        IHidObject argumentValue = (IHidObject)argument.getValue();
                        if (argumentValue == null || !((IRfFieldElement)argument.getKey()).getName().equals("dest_var")) continue;
                        destArgumentValue = argumentValue;
                    }
                }
                if (destArgumentValue instanceof RfHidAccess && ((RfHidAccess)destArgumentValue).getParentHid() != null) {
                    destArgumentValue = ((RfHidAccess)destArgumentValue).getParentHid();
                }
                if (!(destArgumentValue instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement element = ((RfHid)destArgumentValue).getElement();
                if (element == null || !(element instanceof RfAssociatedType)) {
                    return true;
                }
                RfNamedElement elementType = LintUtils.getAssociatedFinalType((RfAssociatedType)element);
                if (elementType == null || !(elementType instanceof RfPredefinedScalarType) || !"string".equals(elementType.getName())) {
                    return true;
                }
                Check_SVTB_6_5_1_1.this.addHit(this.parserPath, hidObject, Check_SVTB_6_5_1_1.this.getFailMessage());
                return true;
            }
        });
        this.checkStaticCast();
    }
}

