/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.6.6.3.1")
@CheckName(value="SVTB.6.6.3.1")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.PERFORMANCE, RuleLabel.ARRAY})
@CheckTitle(value="Do not use the wildcard index")
@CheckDescription(value="Do not use the wildcard (*) index. This can have a performance impact.\nSince any key type is allowed, any time an item is stored in the queue, the simulator must use a dynamic key type that can be any number of bits. During a lookup or search, the simulator must dereference the dynamic keys to check against the input key and this adds unnecessary overhead.\nAlways use explicit types for a key of associative arrays so that the array can be iterated using foreach and other associative array methods\n\nExamples:\nint good_array[ integer ];  // allowed\nint bad_array[ * ]; // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_6_6_3_1
extends OVMComplianceCheck {
    public Check_SVTB_6_6_3_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                Check_SVTB_6_6_3_1.this.notifyCheckAlive();
                if (Check_SVTB_6_6_3_1.this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                if (namedElement instanceof RfField && ((RfField)namedElement).getDeclaration() != null) {
                    Check_SVTB_6_6_3_1.this.checkArrayField((RfField)namedElement);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    private void checkArrayField(RfField field) {
        RfAssociatedType type = field;
        while (type != null) {
            if (this.checkDataType(type.getDataType())) {
                this.addHit(field, "'" + field.getName() + "' uses wildcard (*) index");
                return;
            }
            IRfNamedElement assocType = type.getAssociatedType();
            if (assocType == null || !(assocType instanceof RfTypeAlias)) break;
            type = (RfTypeAlias)assocType;
        }
    }

    private boolean checkDataType(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        return dataType.isAssociativeWildcardArrayForCompliance();
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

