/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.text.MessageFormat;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.6.7.4")
@CheckName(value="SVTB.6.7.4")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.PREDEFINED_METHOD, RuleLabel.ARRAY, RuleLabel.CONCATENATION, RuleLabel.SELECT})
@CheckTitle(value="Use queue methods rather than unpacked array concatenation or array part select")
@CheckDescription(value="This rule checks that all queues are updated using specific methods:\n[queue].insert(), [queue].delete(), [queue].pop_front(), [queue].pop_back(), [queue].push_front(), [queue].push_back()\ninstead of unpacked array concatenation or array part select.\nQueue methods are more clear, more maintainable, and more readable than unpacked array concatenation or array part select.\n\nUse this code as a guide:\nint q[$];\nint old_q[$];\nint e, pos, junk;\n// NOT ALLOWED // ALLOWED\nq = { q, 6 }; // q.push_back(6)\nq = { e, q }; // q.push_front(e)\nq = q[1:$]; // q.pop_front(junk) or q.delete(0)\nq = q[0:$-1]; // q.pop_back(junk) or q.delete(q.size-1)\nq = { q[0:pos-1], e, q[pos:$] }; // q.insert(pos, e)\nq = { q[0:pos], e, q[pos+1:$] }; // q.insert(pos+1, e)\nq = {'}; // q.delete()\n\nDirect indexing of individual elements is allowed:\ne = q[ndx];\nq[ndx] = e;\nLikewise, direct array assignment from a queue is allowed:\nq = old_q;\n\n// IFF allowQueueConcatenation = true\nint q1[$], q2[$], q3[$];\nint arr1[], arr2[];\nq1 = {q2, q3}; // allowed\nq1 = {q2, 5}; // not allowed\nq1 = {arr1, arr2}; // allowed\nq1 = {arr1, 3}; // not allowed\nq1 = {q1, arr1}; // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_6_7_4
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, queues can be updated using unpacked array concatenation of other queues or arrays.", name="allowQueueConcatenation", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowQueueConcatenationValue;

    public Check_SVTB_6_7_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        final LocalHidVisitor localVisitor = new LocalHidVisitor();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!namedElement.isPredefined()) {
                    if (Check_SVTB_6_7_4.this.checkPreWaivers(namedElement.getFile())) {
                        return true;
                    }
                    namedElement.visitHidObject(rfProject, localVisitor);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    protected boolean isValidLeftHandValue(RfHidOperator operator) {
        IHidObject lhValue = operator.getLHValue();
        if (lhValue == null || !(lhValue instanceof RfHid) && !(lhValue instanceof RfHidAccess) && !(lhValue instanceof RfHidImplicit)) {
            return false;
        }
        if (lhValue instanceof RfHidImplicit) {
            ISDataAbstract resolvedType = operator.getOperatorResolvedType();
            if (resolvedType == null || resolvedType instanceof DummyDataType) {
                return false;
            }
            return RfListType.isQueue((IRfScopeElement)SDataUtils.getDataType((ISDataAbstract)resolvedType).getType());
        }
        if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).isSelect()) {
            return RfListType.isQueue((IRfScopeElement)((RfHidAccess)lhValue).getAssociatedType());
        }
        if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).getParentHid() instanceof RfHid) {
            lhValue = ((RfHidAccess)lhValue).getParentHid();
        }
        if (!(lhValue instanceof RfHid)) {
            return false;
        }
        IRfNamedElement leftElement = ((RfHid)lhValue).getElement();
        if (leftElement == null || !(leftElement instanceof RfField)) {
            return false;
        }
        IRfNamedElement leftType = ((RfField)leftElement).getAssociatedType();
        return leftType != null && (RfListType.isQueue((IRfScopeElement)leftType) || leftType instanceof RfTypeAlias && RfListType.isQueue((IRfScopeElement)((RfAssociatedType)leftType).getAssociatedType()));
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private static final String ERROR_MESSAGE = "Array literal assignments used instead of queue methods!";
        private static final String ERROR_MESSAGE_INVALID_ARG = "Array literal assignments used instead of queue methods, concatenation is allowed only for queues and arrays, {0} is neither!";
        private ParserPath parserPath;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator operator = (RfHidOperator)hidObject;
            if (!operator.isEqualAssignment()) {
                return true;
            }
            Check_SVTB_6_7_4.this.notifyCheckAlive();
            if (!Check_SVTB_6_7_4.this.isValidLeftHandValue(operator)) {
                return true;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            for (IHidObject rhValue : rhValues) {
                if (rhValue instanceof RfHidAccess && ((RfHidAccess)rhValue).isSelect()) {
                    List selects = ((RfHidAccess)rhValue).getSelects();
                    for (IHidObject select : selects) {
                        if (!(select instanceof RfHidOperator) || !((RfHidOperator)select).isRangeOrPartSelect()) continue;
                        Check_SVTB_6_7_4.this.addHit(this.parserPath, operator, operator.getQualifiers(), ERROR_MESSAGE);
                        return true;
                    }
                }
                if (rhValue instanceof RfHidImplicit && ((RfHidImplicit)rhValue).isEmptyQueue()) {
                    Check_SVTB_6_7_4.this.addHit(this.parserPath, operator, operator.getQualifiers(), ERROR_MESSAGE);
                    return true;
                }
                if (!(rhValue instanceof RfHidOperator) || !((RfHidOperator)rhValue).isConcatOrAssignPatternOperator()) continue;
                if (!Check_SVTB_6_7_4.this.pAllowQueueConcatenationValue && ((RfHidOperator)rhValue).isVLOGConcatenation(true)) {
                    Check_SVTB_6_7_4.this.addHit(this.parserPath, operator, operator.getQualifiers(), ERROR_MESSAGE);
                    return true;
                }
                if (((RfHidOperator)rhValue).isAssignmentPattern() && !this.checkAssignmentPattern((RfHidOperator)rhValue)) {
                    return true;
                }
                if (!((RfHidOperator)rhValue).isVLOGConcatenation(true) || this.checkConcatenation((RfHidOperator)rhValue)) continue;
                return true;
            }
            return true;
        }

        private boolean checkAssignmentPattern(RfHidOperator assignmentPattern) {
            if (assignmentPattern == null) {
                return true;
            }
            ListContainer rightValues = assignmentPattern.getRHValues();
            if (rightValues == null || rightValues.isEmpty()) {
                return false;
            }
            for (IHidObject value : rightValues) {
                if (!(value instanceof RfHidImplicit || value instanceof RfHid || value instanceof RfHidOperator || value instanceof RfHidAccess)) {
                    return false;
                }
                if (!(value instanceof RfHidOperator)) continue;
                RfHidOperator operator = (RfHidOperator)value;
                if (operator.isVLOGConcatenation(true) && !this.checkConcatenation(operator)) {
                    Check_SVTB_6_7_4.this.addHit(this.parserPath, operator, operator.getQualifiers(), ERROR_MESSAGE);
                    return false;
                }
                if (!operator.isAssignmentPattern() || this.checkAssignmentPattern(operator)) continue;
                Check_SVTB_6_7_4.this.addHit(this.parserPath, operator, operator.getQualifiers(), ERROR_MESSAGE);
                return false;
            }
            return true;
        }

        private boolean checkConcatenation(RfHidOperator concatenation) {
            if (concatenation == null) {
                return true;
            }
            ListContainer rightValues = concatenation.getRHValues();
            if (rightValues == null || rightValues.isEmpty()) {
                return false;
            }
            for (IHidObject concatenatedValue : rightValues) {
                boolean isArray;
                if (!(concatenatedValue instanceof RfHid || concatenatedValue instanceof RfHidAccess || concatenatedValue instanceof RfHidOperator)) {
                    Check_SVTB_6_7_4.this.addHit(this.parserPath, concatenation, concatenation.getQualifiers(), ERROR_MESSAGE);
                    return false;
                }
                if (concatenatedValue instanceof RfHidOperator) {
                    RfHidOperator operator = (RfHidOperator)concatenatedValue;
                    if (operator.isAssignmentPattern() && this.checkAssignmentPattern(operator)) {
                        return true;
                    }
                    Check_SVTB_6_7_4.this.addHit(this.parserPath, concatenation, concatenation.getQualifiers(), ERROR_MESSAGE);
                    return false;
                }
                IRfNamedElement concatenatedType = null;
                String concatenatedName = "";
                if (concatenatedValue instanceof RfHid) {
                    IRfNamedElement concatenatedElement = ((RfHid)concatenatedValue).getElement();
                    if (concatenatedElement == null || !(concatenatedElement instanceof RfField)) continue;
                    concatenatedType = ((RfField)concatenatedElement).getAssociatedType();
                    concatenatedName = concatenatedElement.getName();
                } else if (concatenatedValue instanceof RfHidAccess) {
                    concatenatedType = ((RfHidAccess)concatenatedValue).getAssociatedType();
                    concatenatedName = HidUtils.toNiceString((IHidObject)concatenatedValue);
                }
                while (concatenatedType instanceof RfTypeAlias) {
                    concatenatedType = ((RfTypeAlias)concatenatedType).getAssociatedType();
                }
                boolean isQueue = concatenatedType instanceof RfListType && ((RfListType)concatenatedType).isQueue();
                boolean bl = isArray = concatenatedType instanceof RfListType && ((RfListType)concatenatedType).getUnpackedDimension() != null && !((RfListType)concatenatedType).getUnpackedDimension().isEmpty();
                if (concatenatedType != null && (isQueue || isArray)) continue;
                Check_SVTB_6_7_4.this.addHit(this.parserPath, concatenation, concatenation.getQualifiers(), MessageFormat.format(ERROR_MESSAGE_INVALID_ARG, concatenatedName));
                return false;
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

