/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfStruct;

@CheckVersion(value="16.1.29")
@CheckID(value="SVTB.6.9")
@CheckName(value="SVTB.6.9")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE})
@CheckTitle(value="Do not use anonymous types")
@CheckDescription(value="Do not use anonymous types.\n\nNot Allowed:\n  enum {INIT, START, DONE}  state;\n\nAllowed:\n  typedef enum  {INIT, START, DONE} state_e;\n  state_e  state;")
public class Check_SVTB_6_9
extends OVMComplianceCheck {
    public Check_SVTB_6_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkStructs(this.fOVMProject.getRfProject().getAllStructsUnionsEnums());
    }

    private void checkStructs(List<RfStruct> structs) {
        this.notifyCheckAlive();
        if (structs == null || structs.isEmpty()) {
            return;
        }
        for (RfStruct struct : structs) {
            if (struct.getAliasName() != null) continue;
            this.addHit(struct, "Anonymous " + LintUtils.getElementKind(struct) + " used!");
        }
    }
}

