/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractAllDataTypeUsersCheck;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.12.3")
@CheckName(value="SVTB.7.12.3")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.PARAMETER, RuleLabel.VERIFICATION})
@CheckTitle(value="Explicitly specialize parameterized types using #()")
@CheckDescription(value="Explicitly specialize parameterized types using #(), even when using the default parameter values.\n\nAllowed:\n   transaction#(my_class, my_sub_class, 0) var;\n   typedef transaction#(my_class, my_sub_class, 1) my_type_t;\n\nNot allowed:\n   transaction var;\n   typedef transaction my_type_t;\n\nImplementation Notes:\nThis rule checks types used when declaring variables and functions.\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_12_3
extends AbstractAllDataTypeUsersCheck {
    @CheckParameter(defaultValue="false", description="Allow parameterization with default values using just #().", name="allowDefaultParametrizationValues", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    public boolean pAllowParametrizationWithDefaultValues;

    public Check_SVTB_7_12_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getFailMessage(String typeName) {
        return "Use of parameterized type '" + typeName + "' specialization without #()";
    }

    @Override
    protected boolean checkDataType(RfNamedElement element, DataType dt, RfNamedElement scope) {
        if (element instanceof RfFunction && ((RfFunction)element).isConstructor()) {
            return true;
        }
        int paramsInList = this.geParameterPortListSize(dt, scope);
        if (paramsInList == 0) {
            return true;
        }
        int specializationParamsSize = this.getSpecializationParamsSize(dt, scope);
        if (specializationParamsSize == 0) {
            boolean hasExplicitSpecialization;
            boolean bl = hasExplicitSpecialization = dt.getNamedParamAssignments() != null || dt.getOrderedParamAssignments() != null;
            if (this.pAllowParametrizationWithDefaultValues && hasExplicitSpecialization) {
                return true;
            }
            this.addHitInProperDT(element, dt);
            return false;
        }
        return true;
    }
}

