/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_7_12_3_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractAllDataTypeUsersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.12.3.1")
@CheckName(value="SVTB.7.12.3.1")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.PARAMETER, RuleLabel.VERIFICATION})
@CheckTitle(value="Parameterize type specialization with all parameters")
@CheckDescription(value="This rule checks for missing parameter overrides in any type specialization (classes, modules, interfaces or programs).\nAny parameter should be overriden in type specialization, whether it has a default value set or not, \nfor clarity and to avoid unintended behaviour.\n\nNot allowed:\nclass trans #(parameter type T1 = int, T2 = string);\nendclass\ntrans#(test_class) trans1; // incomplete parameter override\ntrans#() trans2; // default parameters\n\nmodule dut #(parameter int T1 = 8, T2 = 16);\nendmodule\ndut#(.T1(8)) dut1; // incomplete parameter override\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_7_12_3_1.class)
public class Check_SVTB_7_12_3_1
extends AbstractAllDataTypeUsersCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of type full names which can be used without explicitly specifying all parameters.", name="skipTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public HashSet<String> pSkipTypesValue;
    @CheckParameter(defaultValue="false", description="If true, the rule skips the parameters which have other parameters as default value.", name="skipParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    public boolean pSkipParameters;

    public Check_SVTB_7_12_3_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getFailMessage(String typeName) {
        return "Type '" + typeName + "' used without specifying all parameters!";
    }

    @Override
    protected boolean checkDataType(RfNamedElement element, DataType dt, RfNamedElement scope) {
        if (element.getDeclaration() != null && element.getFile() != null && this.fOVMProject.isOVMFile(element.getFile().getName())) {
            return true;
        }
        if (element instanceof RfFunction && ((RfFunction)element).isConstructor()) {
            return true;
        }
        int paramsInList = this.geParameterPortListSize(dt, scope);
        if (paramsInList == 0) {
            return true;
        }
        int specializationParamsSize = this.getSpecializationParamsSize(dt, scope);
        if (this.isSkippedBaseClass(dt, scope)) {
            return true;
        }
        if (specializationParamsSize < paramsInList) {
            this.addHitInProperDT(element, dt);
            return false;
        }
        return true;
    }

    @Override
    protected int checkParameters(List<RfField> params, RfNamedElement scope) {
        int paramsInList = 0;
        HashSet<String> paramNames = new HashSet<String>();
        for (RfField param : params) {
            String paramName = param.getName();
            if (paramName == null || paramName.isEmpty()) continue;
            paramNames.add(paramName);
        }
        for (RfField param : params) {
            if (!param.isInParameterPortList() || param.isLocalParameter() || this.pSkipParameters && paramNames.contains(param.getInitialValue(false))) continue;
            ++paramsInList;
        }
        return paramsInList;
    }

    @Override
    protected int checkNamedParamAssignments(DataType dt, RfNamedElement scope) {
        int namedParamAssignments = super.checkNamedParamAssignments(dt, scope);
        if (!this.pSkipParameters) {
            return namedParamAssignments;
        }
        List<RfField> params = LintUtils.getParamsFromDataType(dt, scope);
        if (params == null) {
            return namedParamAssignments;
        }
        final ArrayList<String> paramNames = new ArrayList<String>();
        for (RfField param : params) {
            String paramName = param.getName();
            if (param.isLocalParameter() || paramName == null || paramName.isEmpty()) continue;
            paramNames.add(paramName);
        }
        int specializationParamsSize = 0;
        final HashSet initializedParams = new HashSet();
        RfHidHolder hidHolder = dt.getParamValuesHolder();
        if (hidHolder == null) {
            return namedParamAssignments;
        }
        hidHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<RfHidOperator>(){

            public boolean visit(RfHidOperator hidOperator) {
                if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_GENERIC_VALUE)) {
                    return true;
                }
                IHidObject lhValue = hidOperator.getLHValue();
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement element = ((RfHid)lhValue).getElement();
                if (element == null || !(element instanceof RfField)) {
                    return true;
                }
                RfField field = (RfField)element;
                if (paramNames.contains(field.getInitialValue(false))) {
                    return true;
                }
                initializedParams.add(((RfField)element).getName());
                return true;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        });
        Map<String, ArgInfo> namedParams = dt.getNamedParamAssignments();
        if (namedParams != null) {
            for (ArgInfo argInfo : namedParams.values()) {
                if (argInfo.getDataType() == null || argInfo.getDataType().getType() == null || argInfo.getDataType().getType().isEmpty() || !initializedParams.contains(argInfo.getName())) continue;
                ++specializationParamsSize;
            }
        }
        return specializationParamsSize;
    }

    private boolean isSkippedBaseClass(DataType dt, RfNamedElement scope) {
        if (dt == null) {
            return false;
        }
        RfAssociatedTypeWrapper wrap = new RfAssociatedTypeWrapper(dt, scope);
        RfNamedElement wrapType = LintUtils.getAssociatedFinalType(wrap);
        if (wrapType == null) {
            return false;
        }
        String fullName = wrapType.getFullName();
        return this.pSkipTypesValue != null && this.pSkipTypesValue.contains(fullName);
    }
}

