/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_7_13;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.13")
@CheckName(value="SVTB.7.13")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.OVERRIDE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Overridden method must be virtual")
@CheckDescription(value="An overridden method must be declared virtual in the base class.\nAn overridden non-virtual method will likely result in unexpected behaviour since a non-virtual method is not polymorphic.\nThis rule flags the non-virtual overridden method declared in the base class.\n\nExamples:\nclass parent;\n  function int f1(); endfunction // not allowed\n  virtual function int f2(); endfunction // allowed\nendclass\n\nclass child extends parent;\n  function int f1(); endfunction\n  function int f2(); endfunction\nendclass\n\nCheck supports auto-correcting.")
@CheckReapplyDisable
@CheckAutofix(value=Autofix_SVTB_7_13.class)
public class Check_SVTB_7_13
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, static functions can be overridden. A static function cannot be declared virtual!", name="allowStaticShadowing", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowStaticShadowingValue;

    public Check_SVTB_7_13(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement classs : this.fOVMProject.getAllNonXVMClasses()) {
            this.checkClass((RfClass)classs);
        }
    }

    private void checkClass(RfClass classs) {
        Set<RfClass> children = classs.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        this.notifyCheckAlive();
        this.checkMethods(classs.getLocalMembers(RfFunction.class), classs, children);
    }

    private void checkMethods(Collection<RfFunction> methods, RfClass classs, Collection<RfClass> children) {
        if (classs == null || methods == null || methods.isEmpty()) {
            return;
        }
        block0: for (RfFunction method : methods) {
            RfFunction virtualMethod;
            if (method == null || method.isPredefined() || this.pAllowStaticShadowingValue && method.isObjectStatic() || (virtualMethod = LintUtils.getVirtualFunction(method)) != null) continue;
            boolean methodFailed = false;
            for (RfClass child : children) {
                if (methodFailed |= this.checkChildClass(new HashSet<RfClass>(), child, method)) continue block0;
            }
        }
    }

    private boolean checkChildClass(Set<RfClass> visited, RfClass classs, RfFunction method) {
        if (visited.contains(classs)) {
            return false;
        }
        visited.add(classs);
        RfFunction localMethod = method.isFunction() ? classs.getFunctionWithPrefix(method.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE) : classs.getTaskWithPrefix(method.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (localMethod != null) {
            this.addHit(method, String.valueOf(method.isFunction() ? "Function" : "Task") + " '" + method.getFullName() + "()' is overridden in sub-class '" + classs.getFullName() + "', but is not declared virtual", new VerissimoAutofixAdditionalInfo(method));
            return true;
        }
        Set<RfClass> children = classs.getChildren();
        if (children == null || children.isEmpty()) {
            return false;
        }
        for (RfClass child : children) {
            if (!this.checkChildClass(visited, child, method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getAdditionalInfoForDisplayString(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (element instanceof RfFunction) {
            return String.valueOf(LintUtils.getElementKind((RfFunction)element)) + " '" + ((RfFunction)element).getName() + "'";
        }
        return null;
    }
}

