/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="3.5.29")
@CheckID(value="SVTB.7.13.1")
@CheckName(value="SVTB.7.13.1")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.OVERRIDE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Repeat the 'virtual' keyword when overriding a virtual method")
@CheckDescription(value="A virtual method must be explicitly declared 'virtual' in all child classes that override it.\nBy looking at the signature of a function, it should be easy to see if it is virtual, without drilling down to find out if someone in a base class wrote ''virtual''.\n\nExamples:\n\nclass c1;\n\tvirtual function int foo(); endfunction\nendclass\nclass c2 extends c1;\n\tvirtual function int foo(); endfunction // allowed\nendclass\n\nclass c3;\n\tvirtual function int bar(); endfunction\nendclass\nclass c4 extends c3;\n\tfunction int bar(); endfunction // not allowed\nendclass\n")
@CheckReapplyDisable
public class Check_SVTB_7_13_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, ignore methods overridden inside macros.", name="hideHitsInsideMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pHideHitsInsideMacrosValue;

    public Check_SVTB_7_13_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass eachClass : this.fOVMProject.getAllClasses()) {
            List<RfFunction> allFunctions = eachClass.getLocalMembers(RfFunction.class);
            if (allFunctions == null) continue;
            for (RfFunction eachFunction : allFunctions) {
                ReparseInfo reparseInfo;
                RfDefElement eachFunctionDeclaration;
                RfFunction topVirtualFunction;
                this.notifyCheckAlive();
                if (eachFunction == null || (topVirtualFunction = LintUtils.getTopVirtualFunction(eachFunction)) == null || eachFunction == topVirtualFunction || eachFunction.hasVirtualQualifier() || this.pHideHitsInsideMacrosValue && (eachFunctionDeclaration = eachFunction.getDeclaration()) != null && (reparseInfo = eachFunctionDeclaration.getReparseInfo()) != null && reparseInfo.getReparseStackSize() != 0) continue;
                this.addHit(eachFunction, "Missing 'virtual' keyword for '" + eachFunction.getFullName() + "()'!");
            }
        }
    }
}

