/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.5.29")
@CheckID(value="SVTB.7.13.2")
@CheckName(value="SVTB.7.13.2")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="If a function is declared 'virtual' then the first definition in the inheritance tree should be 'virtual'")
@CheckDescription(value="The semantic of a non-virtual to virtual switch is confusing.\n\nExamples:\n\nclass c1;\n\tfunction void foo(); endfunction\n\tvirtual function void bar(); endfunction\nendclass\n\nclass c2 extends c1;\n\tvirtual function void foo(); endfunction // not allowed\n\tfunction void bar(); endfunction // allowed\nendclass\n")
@CheckReapplyDisable
public class Check_SVTB_7_13_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, the virtual function and the first definition must have matching signatures.", name="strictFirstDefinition", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pStrictFirstDefinition;

    public Check_SVTB_7_13_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass eachClass : this.fOVMProject.getAllClasses()) {
            List<RfFunction> allFunctions = eachClass.getLocalMembers(RfFunction.class);
            if (allFunctions == null) continue;
            for (RfFunction eachFunction : allFunctions) {
                this.notifyCheckAlive();
                if (eachFunction == null || !eachFunction.hasVirtualQualifier()) continue;
                RfFunction topFunction = null;
                topFunction = !this.pStrictFirstDefinition ? LintUtils.getTopFunction(eachFunction) : LintUtils.getStrictFirstDefinition(eachFunction);
                if (topFunction == null || topFunction.hasVirtualQualifier()) continue;
                this.addHit(eachFunction, "First definition is not 'virtual' for '" + eachFunction.getFullName() + "()'!");
            }
        }
    }
}

