/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.5.29")
@CheckID(value="SVTB.7.13.3")
@CheckName(value="SVTB.7.13.3")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not declare 'local virtual' methods")
@CheckDescription(value="'local virtual' is useless.\n\nExamples:\n\nclass c1;\n\tvirtual function int foo(); endfunction // allowed\n\tlocal virtual function int bar(); endfunction // not allowed\nendclass\n")
public class Check_SVTB_7_13_3
extends OVMComplianceCheck {
    public Check_SVTB_7_13_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass eachClass : this.fOVMProject.getAllClasses()) {
            List<RfFunction> allFunctions = eachClass.getLocalMembers(RfFunction.class);
            if (allFunctions == null) continue;
            for (RfFunction eachFunction : allFunctions) {
                this.notifyCheckAlive();
                if (eachFunction == null || !eachFunction.isPrivate() || !eachFunction.hasVirtualQualifier()) continue;
                this.addHit(eachFunction, "Useless 'local virtual " + eachFunction.getFullName() + "()'!");
            }
        }
    }
}

