/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.3")
@CheckID(value="SVTB.7.13.4")
@CheckName(value="SVTB.7.13.4")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.OVERRIDE, RuleLabel.SHADOWING, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not override non-virtual methods")
@CheckDescription(value="An overridden method must be declared virtual in the base class.\nAn overridden non-virtual method will likely result in unexpected behaviour since a non-virtual method is not polymorphic.\nThis rule flags the overriding method declared in the extending class.\nIt can be used to flag methods that override non-virtual methods from the XVM library.\n\nExamples:\n\nclass c1;\n\tfunction void foo(); endfunction\n\tvirtual function void bar(); endfunction\nendclass\n\nclass c2 extends c1;\n\tfunction void foo(); endfunction // not allowed\n\tfunction void bar(); endfunction // allowed\nendclass\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_SVTB_7_13_4
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, static functions can be overridden. A static function cannot be declared virtual!", name="allowStaticShadowing", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowStaticShadowingValue;

    public Check_SVTB_7_13_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement classs : this.fOVMProject.getAllNonXVMClasses()) {
            this.checkClass((RfClass)classs);
        }
    }

    private void checkClass(RfClass classs) {
        if (classs == null) {
            return;
        }
        RfClass classParent = classs.getParent();
        if (classParent == null) {
            return;
        }
        this.notifyCheckAlive();
        RfFileDef file = classs.getFile();
        if (file == null) {
            return;
        }
        if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) {
            return;
        }
        this.checkMethods(classs.getLocalMembers(RfFunction.class), classParent);
    }

    private void checkMethods(Collection<RfFunction> methods, RfClass parent) {
        if (methods == null || methods.isEmpty() || parent == null) {
            return;
        }
        for (RfFunction method : methods) {
            RfFunction virtualMethod;
            if (method == null || method.isPredefined() || this.pAllowStaticShadowingValue && method.isObjectStatic() || (virtualMethod = LintUtils.getVirtualFunction(method)) != null) continue;
            this.checkMethodInParents(parent, method);
        }
    }

    private void checkMethodInParents(RfClass parent, RfFunction method) {
        if (parent == null) {
            return;
        }
        RfFunction localParentMethod = method.isFunction() ? parent.getFunctionWithPrefix(method.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE) : parent.getTaskWithPrefix(method.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (localParentMethod != null) {
            this.addHit(method, String.valueOf(method.isFunction() ? "Function" : "Task") + " '" + method.getFullName() + "()' overriddes non-virtual method declared in parent class '" + parent.getFullName() + "'");
            return;
        }
        this.checkMethodInParents(parent.getParent(), method);
    }
}

