/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_7_14_0;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.14.0")
@CheckName(value="SVTB.7.14.0")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.OVERRIDE, RuleLabel.METHOD, RuleLabel.SUPER, RuleLabel.VERIFICATION})
@CheckTitle(value="Overriding method must call super")
@CheckDescription(value="All classes that inherit from <baseClass> and implement <methodName>() must call super.<methodName>().\nOptionally, all classes that inherit from <skipBaseClasses> are skipped.\n\nExamples:\nclass parent;\n  function int f1(); endfunction\n  function int f2(); endfunction\nendclass\n\nclass child extends parent;\n  function int f1(); \n    super.f1(); // allowed\n  endfunction\n  function int f2(); endfunction // not allowed\nendclass\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_SVTB_7_14_0.class)
public class Check_SVTB_7_14_0
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="For all classes that inherit from <baseClass>.", name="baseClass", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.STRING)
    private String pBaseClassValue;
    @CheckParameter(defaultValue="", description="If <methodName>() overrides parent implementation, check that it calls super.<methodName>().", name="methodName", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.STRING)
    private String pMethodNameValue;
    @CheckParameter(defaultValue="", description="Comma separated list to filter inheritance subtrees out of the <baseClass> inheritance tree.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipBaseClassesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of package names. Skip classes that inherit directly from classes declared in <skipChildrenOfClassesDefinedInPackages> packages.", name="skipChildrenOfClassesDefinedInPackages", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipChildrenOfClassesDefinedInPackagesValue;
    @CheckParameter(defaultValue="false", description="If true, the rule will not fail if the <baseClass> doesn't exist.", name="ignoreMissingBaseClass", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pIgnoreMissingBaseClass;

    public Check_SVTB_7_14_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass baseClass = this.fOVMProject.getRfProject().getClass(this.pBaseClassValue, true);
        if (baseClass == null) {
            if (!this.pIgnoreMissingBaseClass) {
                this.addHit(null, "Class '" + this.pBaseClassValue + "' not found!");
            }
            return;
        }
        this.checkClasses(new HashSet<RfClass>(), baseClass.getChildren());
    }

    private void checkClasses(Set<RfClass> visited, Collection<RfClass> classes) {
        if (classes == null) {
            return;
        }
        this.notifyCheckAlive();
        for (RfClass clazz : classes) {
            if (visited.contains(clazz)) continue;
            visited.add(clazz);
            if (this.pSkipBaseClassesValue != null && this.pSkipBaseClassesValue.contains(clazz.getFullName())) continue;
            if (!(this.checkPreWaivers(clazz.getFile()) || this.pSkipChildrenOfClassesDefinedInPackagesValue != null && clazz.getParent() != null && clazz.getParent().getEnclosingPackage() != null && this.pSkipChildrenOfClassesDefinedInPackagesValue.contains(clazz.getParent().getEnclosingPackage().getName()))) {
                this.checkSuperCallsInClass(clazz);
            }
            this.checkClasses(visited, clazz.getChildren());
        }
    }

    private void checkSuperCallsInClass(RfClass clazz) {
        RfFunction method = clazz.getConstructorWithPrefix(this.pMethodNameValue, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (method == null) {
            method = clazz.getFunctionWithPrefix(this.pMethodNameValue, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        if (method == null) {
            method = clazz.getTaskWithPrefix(this.pMethodNameValue, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        if (method == null) {
            return;
        }
        List<RfFunctionCall> methodCalls = method.getFunctionCallsWithPrefix("super." + this.pMethodNameValue, 1);
        if (methodCalls != null && !methodCalls.isEmpty()) {
            return;
        }
        this.addHit(method, "'" + LintUtils.getNamedElementFullName(method) + "()' does not call 'super." + this.pMethodNameValue + "()'!", new VerissimoAutofixAdditionalInfo(method));
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

