/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1.6")
@CheckID(value="SVTB.7.15")
@CheckName(value="SVTB.7.15")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.OVERRIDE, RuleLabel.FIELD, RuleLabel.SHADOWING, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not override member variables from parent class")
@CheckDescription(value="Although SystemVerilog allows it, it is not recommended to override a member variable from a parent class.\n\nExamples:\n\nclass c1;\n\tlocal int x;\n\tprotected int x2;\n\tint a;\nendclass\n\nclass c2 extends c1;\n\tlocal int x; // not allowed\n\tprotected int x2; // not allowed\n\tint b; // allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_15
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, local member variables can be overridden.", name="allowLocalMemberOverride", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pAllowLocalMemberOverrideValue;
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_ .", name="skipFieldsDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    HashSet<String> pSkipFieldsDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes, for example uvm_pkg::uvm_ .", name="skipFieldsDeclaredInsideClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    HashSet<String> pSkipFieldsDeclaredInsideClassesWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class member variable patterns to skip, for example uvm_pkg::.*.type_name .", name="skipFieldsByFullNamePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    HashSet<Pattern> pSkipFieldsByFullNamePatternsValue;

    public Check_SVTB_7_15(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> classMembersIteratorKeys = new HashSet<String>();
        classMembersIteratorKeys.add("field");
        for (RfNamedElement eachClass : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (eachClass == null || !(eachClass instanceof RfClass) || this.checkPreWaivers(eachClass.getFile())) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator((RfClass)eachClass, classMembersIteratorKeys, true, this.pSkipFieldsDeclaredInsideMacrosWithPrefixesValue, this.pSkipFieldsDeclaredInsideClassesWithPrefixesValue);
            while (classMembersIterator.hasNext()) {
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null || !(eachMember instanceof RfField)) continue;
                this.checkThatFieldIsNotRedefined((RfClass)eachClass, (RfField)eachMember);
            }
        }
    }

    private void checkThatFieldIsNotRedefined(RfClass aClass, RfField aField) {
        if (aClass == null || aField == null) {
            return;
        }
        RfClass parent = aClass.getParent();
        while (parent != null) {
            List<RfField> potentialCollisions = parent.getFieldsWithPrefix(aField.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            for (RfField potentialCollision : potentialCollisions) {
                if (!potentialCollision.isField() || this.ignoreField(aField, potentialCollision)) continue;
                this.addHit(aField, "Class member variable '" + aField.getFullName() + "'\n redefines member variable '" + parent.getFullName() + "." + potentialCollision.getName() + "' from a parent class!");
            }
            parent = parent.getParent();
        }
    }

    private boolean ignoreField(RfField field, RfField overridenField) {
        if (field == null) {
            return true;
        }
        if (this.pAllowLocalMemberOverrideValue && overridenField != null && overridenField.isPrivate()) {
            return true;
        }
        String fieldFullName = field.getFullName();
        if (fieldFullName == null) {
            return true;
        }
        if (this.pSkipFieldsByFullNamePatternsValue == null) {
            return false;
        }
        for (Pattern pattern : this.pSkipFieldsByFullNamePatternsValue) {
            Matcher m;
            if (pattern == null || !(m = pattern.matcher(fieldFullName)).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

