/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1.6")
@CheckID(value="SVTB.7.16")
@CheckName(value="SVTB.7.16")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.OVERRIDE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Use the virtual keyword when overriding a virtual method")
@CheckDescription(value="Although SystemVerilog allows it, it is recommended to use the 'virtual' keyword when overriding a virtual method.\n\nExamples:\n\nclass c1;\n\tvirtual function void foo(); endfunction\n\tvirtual function void bar(); endfunction\nendclass\n\nclass c2 extends c1;\n\tfunction void foo(); endfunction // not allowed\n\tvirtual function void bar(); endfunction // allowed\nendclass\n")
@CheckReapplyDisable
public class Check_SVTB_7_16
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="skipMethodsDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    HashSet<String> pSkipMethodsDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes, for example uvm_pkg::uvm_.", name="skipMethodsDeclaredInsideClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    HashSet<String> pSkipMethodsDeclaredInsideClassesWithPrefixesValue;

    public Check_SVTB_7_16(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> classMembersIteratorKeys = new HashSet<String>();
        classMembersIteratorKeys.add("function");
        classMembersIteratorKeys.add("task");
        for (RfNamedElement eachClass : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (eachClass == null || !(eachClass instanceof RfClass)) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator((RfClass)eachClass, classMembersIteratorKeys, true, this.pSkipMethodsDeclaredInsideMacrosWithPrefixesValue, this.pSkipMethodsDeclaredInsideClassesWithPrefixesValue);
            while (classMembersIterator.hasNext()) {
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null || !(eachMember instanceof RfFunction)) continue;
                this.checkThatMethodIsOverridenWithVirtual((RfClass)eachClass, (RfFunction)eachMember);
            }
        }
    }

    private void checkThatMethodIsOverridenWithVirtual(RfClass aClass, RfFunction aFunction) {
        if (aClass == null || aFunction == null) {
            return;
        }
        RfClass parent = aClass.getParent();
        while (parent != null) {
            RfFunction overriddenFunction = parent.getLocalMember(RfFunction.class, aFunction.getName(), false);
            if (overriddenFunction != null && overriddenFunction.hasVirtualQualifier() && !aFunction.hasVirtualQualifier()) {
                this.addHit(aFunction, "Class method '" + aFunction.getFullName() + "()'\n overrides '" + overriddenFunction.getFullName() + "()' without the explicit 'virtual' keyword!");
                break;
            }
            parent = parent.getParent();
        }
    }
}

