/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.4")
@CheckID(value="SVTB.7.17")
@CheckName(value="SVTB.7.17")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="A method must be declared with the same static resolution with its ancestors")
@CheckDescription(value="Changing the static resolution in the class inheritance is confusing.\n\nExample:\n   class base;\n      function int foo();endfunction\n      static function int goo();endfunction\n   endclass\n   class child extends base;\n      static function int foo();endfunction // NOT ALLOWED\n      function int goo();endfunction // NOT ALLOWED\n   endclass")
@CheckReapplyDisable
public class Check_SVTB_7_17
extends OVMComplianceCheck {
    public Check_SVTB_7_17(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement classs : this.fOVMProject.getAllNonXVMClasses()) {
            this.checkClass((RfClass)classs);
        }
    }

    private void checkClass(RfClass aClass) {
        this.notifyCheckAlive();
        this.checkMethods(aClass, aClass.getLocalMembers(RfFunction.class));
    }

    private void checkMethods(RfClass aClass, Collection<RfFunction> methods) {
        if (methods == null || methods.isEmpty()) {
            return;
        }
        for (RfFunction method : methods) {
            if (method == null || method.isPredefined()) continue;
            RfElement refMethod = null;
            RfClass refParent = null;
            RfClass parent = aClass.getParent();
            while (parent != null) {
                RfFunction parentMethod = parent.getLocalMember(RfFunction.class, method.getName(), false);
                if (parentMethod != null) {
                    refMethod = parentMethod;
                    refParent = parent;
                }
                parent = parent.getParent();
            }
            if (refMethod == null || method.hasObjectStaticQualifier() == refMethod.hasObjectStaticQualifier()) continue;
            this.addHit(method, String.valueOf(this.getMethodSignature(aClass, method)) + " != " + this.getMethodSignature(refParent, (RfFunction)refMethod));
        }
    }

    private String getMethodSignature(RfClass aClass, RfFunction aFunction) {
        if (aClass == null || aFunction == null) {
            return null;
        }
        return String.valueOf(aFunction.isObjectStatic() ? "static" : "") + " " + aClass.getName() + "." + aFunction.getName() + "()";
    }
}

