/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;

@CheckVersion(value="3.5.29")
@CheckID(value="SVTB.7.18")
@CheckName(value="SVTB.7.18")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Class member variables should be local, unless random")
@CheckDescription(value="Member variables visible to public or derived classes are bad since anyone can access them without notice.\nMember vars are usually implementation detail and should not be shared beyond the class context.\nExamples:\n\nclass c1;\n\tlocal int a; // allowed\n\tprotected int b; // not allowed\n\tint c; // not allowed\nendclass\n")
public class Check_SVTB_7_18
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, protected class member variables are allowed.", name="allowProtected", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowProtectedValue;

    public Check_SVTB_7_18(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass eachClass : this.fOVMProject.getAllClasses()) {
            List<RfField> allFields = eachClass.getLocalMembers(RfField.class);
            if (allFields == null) continue;
            for (RfField eachField : allFields) {
                this.notifyCheckAlive();
                if (eachField == null || !eachField.isField() || eachField.isFromEmbeddedCovergroupDef() || eachField.isRand() || eachField.isRandc() || this.pAllowProtectedValue && eachField.isProtected() || eachField.isPrivate()) continue;
                if (this.pAllowProtectedValue) {
                    this.addHit(eachField, "'" + eachField.getFullName() + "' is public!");
                    continue;
                }
                this.addHit(eachField, "'" + eachField.getFullName() + "' is not local!");
            }
        }
    }
}

