/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.5.36")
@CheckID(value="SVTB.7.19")
@CheckName(value="SVTB.7.19")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="All non-static non-local functions must be declared virtual")
@CheckDescription(value="The small performance benefit of non-virtual is not generally worth the additional complexity.\nHowever, if derived.foo() has a signature (number / type of arguments) different from base.foo(), they are not flagged.\n\nExamples:\n\nclass c1;\n\tfunction void f1(); endfunction // not allowed\n\tlocal function void f2(); endfunction // allowed\n\tstatic function void f3(); endfunction // allowed\n\tvirtual function void f4(); endfunction // allowed\nendclass\n")
public class Check_SVTB_7_19
extends OVMComplianceCheck {
    private Set<String> shadowedFunctions;

    public Check_SVTB_7_19(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.shadowedFunctions = new HashSet<String>();
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        ArrayList potentialHits = new ArrayList();
        IRfNamedElementVisitor neVisitor = namedElement -> {
            RfFunction functionElement;
            RfNamedElement enclosingScope;
            if (namedElement instanceof RfFunction && (enclosingScope = (functionElement = (RfFunction)namedElement).getEnclosingScope()) instanceof RfClass) {
                RfFunction topVirtualFunction;
                this.notifyCheckAlive();
                if (!(functionElement.isPredefined() || functionElement.isConstructor() || functionElement.isPrivate() || functionElement.isObjectStatic() || (topVirtualFunction = LintUtils.getTopVirtualFunction(functionElement)) != null)) {
                    this.analyzeInheritance(functionElement);
                    potentialHits.add(functionElement);
                }
            }
            return true;
        };
        rfProject.accept(neVisitor);
        for (RfFunction functionElement : potentialHits) {
            if (this.shadowedFunctions.contains(functionElement.getFullName())) continue;
            this.addHit(functionElement, String.valueOf(functionElement.isPublic() ? "Public" : "") + (functionElement.isProtected() ? "Protected" : "") + " " + (functionElement.isFunction() ? "function" : "task") + " '" + functionElement.getFullName() + "()' should be virtual!");
        }
    }

    private void analyzeInheritance(RfFunction function) {
        RfNamedElement enclosingScope = function.getEnclosingScope();
        if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
            return;
        }
        RfClass enclosingClass = (RfClass)enclosingScope;
        List<RfField> functionArgs = function.getArgumentsWithPrefix("", 2);
        ArrayList<RfNamedElement> functionArgsType = new ArrayList<RfNamedElement>();
        if (functionArgs != null) {
            for (RfField functionArg : functionArgs) {
                functionArgsType.add(LintUtils.getAssociatedFinalType(functionArg));
            }
        }
        RfClass parentClass = enclosingClass.getParent();
        while (parentClass != null) {
            boolean shadow = false;
            RfFunction parentFunction = parentClass.getLocalMember(RfFunction.class, function.getName(), false);
            if (parentFunction != null) {
                List<RfField> parentFunctionArgs = parentFunction.getArgumentsWithPrefix("", 2);
                if (functionArgsType.isEmpty()) {
                    if (parentFunctionArgs != null && !parentFunctionArgs.isEmpty()) {
                        shadow = true;
                    }
                } else if (parentFunctionArgs == null || functionArgsType.size() != parentFunctionArgs.size()) {
                    shadow = true;
                } else {
                    int i = 0;
                    while (i < functionArgsType.size()) {
                        RfNamedElement functionArgType = (RfNamedElement)functionArgsType.get(i);
                        if (i < parentFunctionArgs.size()) {
                            RfNamedElement parentFunctionArgType = LintUtils.getAssociatedFinalType(parentFunctionArgs.get(i));
                            if (functionArgType != null && parentFunctionArgType != null && !functionArgType.getFullName().equals(parentFunctionArgType.getFullName())) {
                                shadow = true;
                            }
                        } else {
                            shadow = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (shadow) {
                this.shadowedFunctions.add(function.getFullName());
                if (parentFunction != null) {
                    this.shadowedFunctions.add(parentFunction.getFullName());
                }
            }
            parentClass = parentClass.getParent();
        }
    }
}

