/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractDeclarationOrderCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.1.1")
@CheckName(value="SVTB.7.1.1")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.STYLING, RuleLabel.VERIFICATION})
@CheckTitle(value="Class declaration order")
@CheckDescription(value="Always declare class elements in a specific order. This keeps the class interface readable and consistent.\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_1_1
extends AbstractDeclarationOrderCheck {
    private static final String VARIABLE = "variable";
    private static final String REGISTERED_VARIABLE = "registered_variable";
    private static final String UNREGISTERED_VARIABLE = "unregistered_variable";
    private static final String CONSTRAINT = "constraint";
    private static final String CONSTRUCTOR = "constructor";
    private static final String UVM_PHASE = "uvm_phase";
    private static final String OVM_PHASE = "ovm_phase";
    private static final String METHOD = "method";
    private static final String COVERAGE = "coverage";
    private static final String FACTORY_REGISTRATION_MACRO = "factory_registration_macro";
    private static final String TLM_PORT = "tlm_port";
    private static final String TLM_EXPORT = "tlm_export";
    private static final String VIRTUAL_INTERFACE = "virtual_interface";
    private Set<String> xvmPhasesNames;
    private Map<String, Integer> xvmPhasesOrdered;
    private RfClass baseXvmComponentClass;
    private static final HashSet<String> legalElements = new LinkedHashSet<String>();
    final String[] fFactoryMacrosOVM = new String[]{"`ovm_sequence_utils", "`ovm_sequence_utils_begin", "`ovm_component_utils", "`ovm_component_param_utils", "`ovm_component_utils_begin", "`ovm_component_param_utils_begin", "`ovm_object_utils", "`ovm_object_param_utils", "`ovm_object_utils_begin", "`ovm_object_param_utils_begin", "`ovm_sequencer_utils", "`ovm_sequencer_param_utils", "`ovm_sequencer_utils_begin", "`ovm_sequencer_param_utils_begin"};
    final String[] fFactoryMacrosUVM = new String[]{"`uvm_sequence_utils", "`uvm_sequence_utils_begin", "`uvm_component_utils", "`uvm_component_param_utils", "`uvm_component_utils_begin", "`uvm_component_param_utils_begin", "`uvm_object_utils", "`uvm_object_param_utils", "`uvm_object_utils_begin", "`uvm_object_param_utils_begin", "`uvm_sequencer_utils", "`uvm_sequencer_param_utils", "`uvm_sequencer_utils_begin", "`uvm_sequencer_param_utils_begin"};
    private final Pattern XVM_BASE_PORT_PATTERN = Pattern.compile(this.fOVMProject.getLibraryKind() == 1 ? "^ovm_.*_port$" : "^uvm_.*_port$");
    private final Pattern XVM_BASE_EXPORT_PATTERN = Pattern.compile(this.fOVMProject.getLibraryKind() == 1 ? "^ovm_.*_export$" : "^uvm_.*_export$");
    final boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
    final Set<String> factoryRegistrationMacros = this.isOVMLib ? new HashSet<String>(Arrays.asList(this.fFactoryMacrosOVM)) : new HashSet<String>(Arrays.asList(this.fFactoryMacrosUVM));
    final Set<String> fieldRegistrationMacros = this.isOVMLib ? new HashSet<String>(Arrays.asList(XVMMacros.OVM_FIELD_MACROS)) : new HashSet<String>(Arrays.asList(XVMMacros.UVM_FIELD_MACROS));
    final Set<String> fieldEnumRegistrationMacros = this.isOVMLib ? new HashSet<String>(Arrays.asList("`ovm_field_enum", "`ovm_field_queue_enum", "`ovm_field_array_enum", "`ovm_field_sarray_enum", "`ovm_field_aa_int_enumkey")) : new HashSet<String>(Arrays.asList("`uvm_field_enum", "`uvm_field_queue_enum", "`uvm_field_array_enum", "`uvm_field_sarray_enum", "`uvm_field_aa_int_enumkey"));
    @CheckParameter(defaultValue="variable,constraint,constructor,method,coverage", description="Specifies which elements are checked and the declaration order. Comma separated list of variable, registered_variable, unregistered_variable, constraint, constructor, xvm_phase, method, coverage, factory_registration_macro, tlm_port, tlm_export, virtual_interface.", name="elementsDeclarationOrder", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pElementsDeclarationOrder;
    @CheckParameter(defaultValue="", description="Comma separated list of names of macros to be skipped.", name="skipMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipMacros;

    static {
        legalElements.add(VARIABLE);
        legalElements.add(REGISTERED_VARIABLE);
        legalElements.add(UNREGISTERED_VARIABLE);
        legalElements.add(CONSTRAINT);
        legalElements.add(CONSTRUCTOR);
        legalElements.add(UVM_PHASE);
        legalElements.add(OVM_PHASE);
        legalElements.add(METHOD);
        legalElements.add(COVERAGE);
        legalElements.add(FACTORY_REGISTRATION_MACRO);
        legalElements.add(TLM_PORT);
        legalElements.add(TLM_EXPORT);
        legalElements.add(VIRTUAL_INTERFACE);
    }

    public Check_SVTB_7_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_CLASS_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_CLASS_MACROS));
        aRfProject.lintTrackMacrosByNames("class", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        LinkedHashSet<String> declarationOrder = new LinkedHashSet<String>();
        if (this.pElementsDeclarationOrder.isEmpty()) {
            declarationOrder.add(VARIABLE);
            declarationOrder.add(CONSTRAINT);
            declarationOrder.add(CONSTRUCTOR);
            declarationOrder.add(METHOD);
            declarationOrder.add(COVERAGE);
        } else {
            String[] elements;
            String[] stringArray = elements = this.pElementsDeclarationOrder.split(",");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                String elementType = element.trim();
                if (!legalElements.contains(elementType)) {
                    this.signalParamError("'" + elementType + "' is not a valid element type, use the following instead: " + this.getLegalElements() + "!", false);
                    return;
                }
                if (declarationOrder.contains(elementType)) {
                    this.signalParamError("Duplicate element type '" + elementType + "'!", false);
                    return;
                }
                declarationOrder.add(elementType);
                ++n2;
            }
            if (declarationOrder.contains(VARIABLE) && (declarationOrder.contains(REGISTERED_VARIABLE) || declarationOrder.contains(UNREGISTERED_VARIABLE))) {
                this.signalParamError("'variable' cannot be used together with 'registered_variable' / 'unregistered_variable'!", false);
                return;
            }
            if (declarationOrder.contains(UVM_PHASE) || declarationOrder.contains(OVM_PHASE)) {
                this.baseXvmComponentClass = this.fOVMProject.fOvmComponent;
                if (this.baseXvmComponentClass == null) {
                    return;
                }
                if (this.fOVMProject.getLibraryKind() == 1) {
                    this.xvmPhasesNames = LintUtilsConstants.OVM_COMPONENT_PHASES_NAMES_ORDERED.keySet();
                    this.xvmPhasesOrdered = LintUtilsConstants.OVM_COMPONENT_PHASES_NAMES_ORDERED;
                } else if (this.fOVMProject.getLibraryKind() == 2) {
                    this.xvmPhasesNames = LintUtilsConstants.UVM_COMPONENT_PHASES_NAMES_ORDERED.keySet();
                    this.xvmPhasesOrdered = LintUtilsConstants.UVM_COMPONENT_PHASES_NAMES_ORDERED;
                }
            }
        }
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            AbstractDeclarationOrderCheck.HitElement hitElement;
            this.notifyCheckAlive();
            RfFileDef fileDef = clazz.getFile();
            if (fileDef != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this)) continue;
            LinkedHashSet<Object> declarations = new LinkedHashSet<Object>();
            Iterator elementsIterator = declarationOrder.iterator();
            Set<String> macroCallParameters = null;
            if (declarationOrder.contains(REGISTERED_VARIABLE) || declarationOrder.contains(UNREGISTERED_VARIABLE)) {
                macroCallParameters = this.getMacroCallParameters((RfClass)clazz);
            }
            while (elementsIterator.hasNext()) {
                String elementType = (String)elementsIterator.next();
                if (VARIABLE.equals(elementType)) {
                    this.getVariables((RfClass)clazz, declarations, macroCallParameters, true, true);
                    continue;
                }
                if (REGISTERED_VARIABLE.equals(elementType)) {
                    this.getVariables((RfClass)clazz, declarations, macroCallParameters, true, false);
                    continue;
                }
                if (UNREGISTERED_VARIABLE.equals(elementType)) {
                    this.getVariables((RfClass)clazz, declarations, macroCallParameters, false, true);
                    continue;
                }
                if (CONSTRAINT.equals(elementType)) {
                    this.getConstraints((RfClass)clazz, declarations);
                    continue;
                }
                if (FACTORY_REGISTRATION_MACRO.equals(elementType)) {
                    this.getFactoryRegistrationMacros((RfClass)clazz, declarations);
                    continue;
                }
                if (CONSTRUCTOR.equals(elementType)) {
                    this.getConstructor((RfClass)clazz, declarations);
                    continue;
                }
                if (UVM_PHASE.equals(elementType) || OVM_PHASE.equals(elementType)) {
                    this.getMethods((RfClass)clazz, declarations, true);
                    continue;
                }
                if (METHOD.equals(elementType)) {
                    this.getMethods((RfClass)clazz, declarations, false);
                    continue;
                }
                if (COVERAGE.equals(elementType)) {
                    this.getCoverage((RfClass)clazz, declarations);
                    continue;
                }
                if (TLM_PORT.equals(elementType)) {
                    this.getPorts((RfClass)clazz, declarations);
                    continue;
                }
                if (TLM_EXPORT.equals(elementType)) {
                    this.getExports((RfClass)clazz, declarations);
                    continue;
                }
                if (!VIRTUAL_INTERFACE.equals(elementType)) continue;
                this.getVirtualInterfaces((RfClass)clazz, declarations);
            }
            if (declarations.isEmpty() || (hitElement = this.checkDeclarationOrder(declarations)) == null) continue;
            Object current = hitElement.getCurrent();
            Object previous = hitElement.getPrevious();
            String currentType = this.getType(current, macroCallParameters, declarationOrder);
            String previousType = this.getType(previous, macroCallParameters, declarationOrder);
            String file = LintUtils.getFileShortName(Check_SVTB_7_1_1.getParserPath((Object)previous).path);
            String enclosingClassName = "";
            if (current instanceof RfNamedElement) {
                enclosingClassName = LintUtils.getNamedElementFullName(((RfNamedElement)current).getEnclosingScope(RfClass.class));
            } else if (previous instanceof RfNamedElement) {
                enclosingClassName = LintUtils.getNamedElementFullName(((RfNamedElement)previous).getEnclosingScope(RfClass.class));
            }
            String hitMessage = "Class '" + enclosingClassName + "' declaration order has " + currentType + " '" + Check_SVTB_7_1_1.getName(current) + "' declared before " + previousType + " '" + Check_SVTB_7_1_1.getName(previous) + "' " + this.link("defined at line " + Check_SVTB_7_1_1.getLine(previous) + " in file '" + file + "'", Check_SVTB_7_1_1.getParserPath((Object)previous).path, Check_SVTB_7_1_1.getLine(previous)) + "!";
            this.addHit(Check_SVTB_7_1_1.getParserPath(current), Check_SVTB_7_1_1.getLine(current), hitMessage, Check_SVTB_7_1_1.getReparseInfo(current));
        }
    }

    private String getLegalElements() {
        StringBuilder legalElementsStr = new StringBuilder("");
        for (String element : legalElements) {
            legalElementsStr.append(String.valueOf(element) + ", ");
        }
        legalElementsStr.delete(legalElementsStr.length() - 2, legalElementsStr.length());
        return legalElementsStr.toString();
    }

    private void getVariables(RfClass clazz, LinkedHashSet<Object> declarations, Set<String> macroCallParameters, boolean checkRegistered, boolean checkUnregistered) {
        List<RfField> fields = clazz.getLocalFields();
        if (fields == null || fields.isEmpty()) {
            return;
        }
        Collections.sort(fields, COMPARATOR);
        LinkedList<RfField> tmpFields = new LinkedList<RfField>();
        for (RfField field : fields) {
            if (field == null || XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || this.pElementsDeclarationOrder.contains(TLM_PORT) && this.isFieldTLMPort(field) || this.pElementsDeclarationOrder.contains(TLM_EXPORT) && this.isFieldTLMExport(field) || this.pElementsDeclarationOrder.contains(VIRTUAL_INTERFACE) && this.isFieldVirtualInterface(field) || LintUtils.isInsideMacroWithName(field, this.pSkipMacros) || field.isFromEmbeddedCovergroupDef()) continue;
            if (checkRegistered && checkUnregistered) {
                tmpFields.add(field);
                continue;
            }
            if (checkRegistered && !checkUnregistered) {
                if (macroCallParameters == null || !macroCallParameters.contains(field.getName())) continue;
                tmpFields.add(field);
                continue;
            }
            if (checkRegistered || !checkUnregistered || macroCallParameters != null && macroCallParameters.contains(field.getName())) continue;
            tmpFields.add(field);
        }
        if (!tmpFields.isEmpty()) {
            declarations.add(tmpFields.get(0));
            declarations.add(tmpFields.get(tmpFields.size() - 1));
        }
    }

    private void getConstraints(final RfClass clazz, LinkedHashSet<Object> declarations) {
        final ArrayList constraints = new ArrayList();
        clazz.accept(this.fOVMProject.getRfProject(), new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (LintUtils.isInsideMacroWithName(namedElement, Check_SVTB_7_1_1.this.pSkipMacros)) {
                    return true;
                }
                RfClass enclosingClass = namedElement.getEnclosingScope(RfClass.class);
                if (namedElement instanceof RfConstraint && enclosingClass != null && clazz.equals(enclosingClass) && !XVMLintUtils.isInOVMMacroCall(Check_SVTB_7_1_1.this.fOVMProject, namedElement)) {
                    constraints.add((RfConstraint)namedElement);
                }
                return true;
            }
        });
        Collections.sort(constraints, COMPARATOR);
        if (!constraints.isEmpty()) {
            declarations.add(constraints.get(0));
            declarations.add(constraints.get(constraints.size() - 1));
        }
    }

    private void getFactoryRegistrationMacros(RfClass clazz, LinkedHashSet<Object> declarations) {
        MacroCallInfo macroInfo = clazz.getMacroCallInfo();
        if (macroInfo == null) {
            return;
        }
        List<MacroCallItem> allMacrosUsed = macroInfo.getItems();
        if (allMacrosUsed == null) {
            return;
        }
        Collections.sort(allMacrosUsed, COMPARATOR);
        LinkedList<MacroCallItem> tmpFactoryRegistrationMacros = new LinkedList<MacroCallItem>();
        for (MacroCallItem macroCall : allMacrosUsed) {
            if (!this.factoryRegistrationMacros.contains(macroCall.getName()) || macroCall.getReparseInfo().getReparseStackSize() != 0) continue;
            tmpFactoryRegistrationMacros.add(macroCall);
        }
        if (!tmpFactoryRegistrationMacros.isEmpty()) {
            declarations.add(tmpFactoryRegistrationMacros.get(0));
            declarations.add(tmpFactoryRegistrationMacros.get(tmpFactoryRegistrationMacros.size() - 1));
        }
    }

    private void getConstructor(final RfClass clazz, final LinkedHashSet<Object> declarations) {
        clazz.accept(this.fOVMProject.getRfProject(), new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfFunction)) {
                    return true;
                }
                if (namedElement instanceof RfPredefinedFunction) {
                    return true;
                }
                if (!((RfFunction)namedElement).isConstructor()) {
                    return true;
                }
                if (LintUtils.isInsideMacroWithName(namedElement, Check_SVTB_7_1_1.this.pSkipMacros)) {
                    return true;
                }
                RfClass enclosingClass = namedElement.getEnclosingScope(RfClass.class);
                if ("new".equals(namedElement.getName()) && enclosingClass != null && clazz.equals(enclosingClass)) {
                    declarations.add(namedElement);
                }
                return true;
            }
        });
    }

    private void getMethods(final RfClass clazz, LinkedHashSet<Object> declarations, final boolean collectOnlyXvmPhases) {
        final ArrayList functions = new ArrayList();
        clazz.accept(this.fOVMProject.getRfProject(), new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfFunction)) {
                    return true;
                }
                if (namedElement instanceof RfPredefinedFunction) {
                    return true;
                }
                if (!((RfFunction)namedElement).isFunction() && !((RfFunction)namedElement).isTask()) {
                    return true;
                }
                if (((RfFunction)namedElement).isConstructor()) {
                    return true;
                }
                if (namedElement.getEnclosingScope() instanceof RfCovergroup && namedElement.getName() != null && namedElement.getName().equals("sample")) {
                    return true;
                }
                if (LintUtils.isInsideMacroWithName(namedElement, Check_SVTB_7_1_1.this.pSkipMacros)) {
                    return true;
                }
                if ((Check_SVTB_7_1_1.this.pElementsDeclarationOrder.contains(Check_SVTB_7_1_1.UVM_PHASE) || Check_SVTB_7_1_1.this.pElementsDeclarationOrder.contains(Check_SVTB_7_1_1.OVM_PHASE)) && !collectOnlyXvmPhases && Check_SVTB_7_1_1.this.baseXvmComponentClass != null && LintUtils.isSubClassOf(clazz, Check_SVTB_7_1_1.this.baseXvmComponentClass) && Check_SVTB_7_1_1.this.xvmPhasesNames.contains(namedElement.getName())) {
                    return true;
                }
                RfClass enclosingClass = namedElement.getEnclosingScope(RfClass.class);
                if (enclosingClass != null && clazz.equals(enclosingClass)) {
                    if (collectOnlyXvmPhases) {
                        if (!LintUtils.isSubClassOf(clazz, Check_SVTB_7_1_1.this.baseXvmComponentClass)) {
                            return true;
                        }
                        if (!Check_SVTB_7_1_1.this.xvmPhasesNames.contains(namedElement.getName())) {
                            return true;
                        }
                        functions.add((RfFunction)namedElement);
                        return true;
                    }
                    if (!XVMLintUtils.isInOVMMacroCall(Check_SVTB_7_1_1.this.fOVMProject, namedElement)) {
                        functions.add((RfFunction)namedElement);
                    }
                }
                return true;
            }
        });
        if (collectOnlyXvmPhases) {
            functions.sort((f1, f2) -> {
                Integer rank1 = this.xvmPhasesOrdered.get(f1.getName());
                Integer rank2 = this.xvmPhasesOrdered.get(f2.getName());
                return rank1.compareTo(rank2);
            });
            if (!functions.isEmpty()) {
                declarations.addAll(functions);
            }
        } else {
            Collections.sort(functions, COMPARATOR);
            if (!functions.isEmpty()) {
                declarations.add(functions.get(0));
                declarations.add(functions.get(functions.size() - 1));
            }
        }
    }

    private void getCoverage(final RfClass clazz, LinkedHashSet<Object> declarations) {
        final ArrayList covergroups = new ArrayList();
        clazz.accept(this.fOVMProject.getRfProject(), new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfCovergroup)) {
                    return true;
                }
                if (LintUtils.isInsideMacroWithName(namedElement, Check_SVTB_7_1_1.this.pSkipMacros)) {
                    return true;
                }
                RfClass enclosingClass = namedElement.getEnclosingScope(RfClass.class);
                if (enclosingClass != null && clazz.equals(enclosingClass) && !XVMLintUtils.isInOVMMacroCall(Check_SVTB_7_1_1.this.fOVMProject, namedElement)) {
                    covergroups.add((RfCovergroup)namedElement);
                }
                return true;
            }
        });
        Collections.sort(covergroups, COMPARATOR);
        if (!covergroups.isEmpty()) {
            declarations.add(covergroups.get(0));
            declarations.add(covergroups.get(covergroups.size() - 1));
        }
    }

    private void getPorts(RfClass clazz, LinkedHashSet<Object> declarations) {
        List<RfField> fields = clazz.getLocalFields();
        if (fields == null || fields.isEmpty()) {
            return;
        }
        Collections.sort(fields, COMPARATOR);
        ArrayList<RfField> ports = new ArrayList<RfField>();
        for (RfField field : fields) {
            if (field == null || XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || LintUtils.isInsideMacroWithName(field, this.pSkipMacros) || !this.isFieldTLMPort(field)) continue;
            ports.add(field);
        }
        if (!ports.isEmpty()) {
            declarations.add(ports.get(0));
            declarations.add(ports.get(ports.size() - 1));
        }
    }

    private void getExports(RfClass clazz, LinkedHashSet<Object> declarations) {
        List<RfField> fields = clazz.getLocalFields();
        if (fields == null || fields.isEmpty()) {
            return;
        }
        Collections.sort(fields, COMPARATOR);
        ArrayList<RfField> exports = new ArrayList<RfField>();
        for (RfField field : fields) {
            if (field == null || XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || LintUtils.isInsideMacroWithName(field, this.pSkipMacros) || !this.isFieldTLMExport(field)) continue;
            exports.add(field);
        }
        if (!exports.isEmpty()) {
            declarations.add(exports.get(0));
            declarations.add(exports.get(exports.size() - 1));
        }
    }

    private void getVirtualInterfaces(RfClass clazz, LinkedHashSet<Object> declarations) {
        List<RfField> fields = clazz.getLocalFields();
        if (fields == null || fields.isEmpty()) {
            return;
        }
        Collections.sort(fields, COMPARATOR);
        ArrayList<RfField> virtualInterfaces = new ArrayList<RfField>();
        for (RfField field : fields) {
            if (field == null || XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || LintUtils.isInsideMacroWithName(field, this.pSkipMacros) || !this.isFieldVirtualInterface(field)) continue;
            virtualInterfaces.add(field);
        }
        if (!virtualInterfaces.isEmpty()) {
            declarations.add(virtualInterfaces.get(0));
            declarations.add(virtualInterfaces.get(virtualInterfaces.size() - 1));
        }
    }

    private boolean isFieldTLMPort(RfField field) {
        IRfNamedElement type = LintUtils.getAssociatedFinalDataType(field).getAssocType();
        if (!(type instanceof RfClass)) {
            return false;
        }
        RfClass classType = (RfClass)type;
        while (classType != null) {
            if (this.XVM_BASE_PORT_PATTERN.matcher(classType.getName()).matches()) {
                return true;
            }
            classType = classType.getParent();
        }
        return false;
    }

    private boolean isFieldTLMExport(RfField field) {
        IRfNamedElement type = LintUtils.getAssociatedFinalDataType(field).getAssocType();
        if (!(type instanceof RfClass)) {
            return false;
        }
        RfClass classType = (RfClass)type;
        while (classType != null) {
            if (this.XVM_BASE_EXPORT_PATTERN.matcher(classType.getName()).matches()) {
                return true;
            }
            classType = classType.getParent();
        }
        return false;
    }

    private boolean isFieldVirtualInterface(RfField field) {
        RfNamedElement fieldType = LintUtils.getAssociatedFinalType(field);
        return fieldType != null && fieldType instanceof RfInterface;
    }

    private Set<String> getMacroCallParameters(RfClass clazz) {
        MacroCallInfo macroInfo = clazz.getMacroCallInfo();
        if (macroInfo == null) {
            return null;
        }
        List<MacroCallItem> allMacrosUsed = macroInfo.getItems();
        if (allMacrosUsed == null) {
            return null;
        }
        HashSet<String> macroCallParameters = new HashSet<String>();
        for (MacroCallItem macroCall : allMacrosUsed) {
            String[] parameters;
            if (!this.fieldRegistrationMacros.contains(macroCall.getName()) || (parameters = macroCall.getMacroParameters()).length == 0) continue;
            if (this.fieldEnumRegistrationMacros.contains(macroCall.getName())) {
                macroCallParameters.add(parameters[1]);
                continue;
            }
            macroCallParameters.add(parameters[0]);
        }
        return macroCallParameters;
    }

    private String getType(Object obj, Set<String> macroCallParameters, Set<String> declarationOrder) {
        if (obj instanceof RfField) {
            if (this.pElementsDeclarationOrder.contains(VIRTUAL_INTERFACE) && this.isFieldVirtualInterface((RfField)obj)) {
                return "virtual interface";
            }
            if (this.pElementsDeclarationOrder.contains(TLM_PORT) && this.isFieldTLMPort((RfField)obj)) {
                return "tlm port";
            }
            if (this.pElementsDeclarationOrder.contains(TLM_EXPORT) && this.isFieldTLMExport((RfField)obj)) {
                return "tlm export";
            }
            if (declarationOrder.contains(VARIABLE)) {
                return VARIABLE;
            }
            if (macroCallParameters == null || !macroCallParameters.contains(Check_SVTB_7_1_1.getName(obj))) {
                return "unregistered variable";
            }
            if (macroCallParameters.contains(Check_SVTB_7_1_1.getName(obj))) {
                return "registered variable";
            }
        }
        if (obj instanceof RfConstraint) {
            return CONSTRAINT;
        }
        if (obj instanceof RfFunction) {
            if (this.xvmPhasesNames != null && ((RfFunction)obj).getName() != null && this.xvmPhasesNames.contains(((RfFunction)obj).getName())) {
                RfClass enclosingScope = ((RfFunction)obj).getEnclosingScope(RfClass.class);
                if (this.baseXvmComponentClass != null && enclosingScope != null && LintUtils.isSubClassOf(enclosingScope, this.baseXvmComponentClass)) {
                    return this.fOVMProject.getLibraryKind() == 1 ? OVM_PHASE : UVM_PHASE;
                }
            }
            if (((RfFunction)obj).isConstructor()) {
                return CONSTRUCTOR;
            }
            if (((RfFunction)obj).isFunction()) {
                return "function";
            }
            if (((RfFunction)obj).isTask()) {
                return "task";
            }
            return "";
        }
        if (obj instanceof RfCovergroup) {
            return "covergroup";
        }
        if (obj instanceof MacroCallItem) {
            return "factory registration macro";
        }
        return "";
    }

    @Override
    protected AbstractDeclarationOrderCheck.HitElement checkDeclarationOrder(Collection<Object> declarations) {
        if (declarations.size() > 1) {
            Object[] declarationsArray = declarations.toArray();
            Object previous = declarationsArray[0];
            int i = 1;
            while (i < declarationsArray.length) {
                Object current = declarationsArray[i];
                int previousLine = Check_SVTB_7_1_1.getLine(previous);
                int currentLine = Check_SVTB_7_1_1.getLine(current);
                if (current instanceof RfNamedElement && previous instanceof RfNamedElement) {
                    RfNamedElement previousNamedElement = (RfNamedElement)previous;
                    RfNamedElement currentNamedElement = (RfNamedElement)current;
                    RfDefElement previousDefElement = previousNamedElement.getDeclaration();
                    RfDefElement currentDefElement = currentNamedElement.getDeclaration();
                    ReparseInfo previousReparseInfo = previousDefElement.getReparseInfo();
                    ReparseInfo currentReparseInfo = currentDefElement.getReparseInfo();
                    if (previousReparseInfo != null && currentReparseInfo != null && previousReparseInfo.getReparseStackSize() > 0 && currentReparseInfo.getReparseStackSize() > 0) {
                        ReparseInfo.ReparseElement[] previousReparseStack = previousReparseInfo.getReparseStack();
                        ReparseInfo.ReparseElement[] currentReparseStack = currentReparseInfo.getReparseStack();
                        int lastCommonReparseElementIndex = -1;
                        int length = previousReparseStack.length < currentReparseStack.length ? previousReparseStack.length : currentReparseStack.length;
                        int j = 0;
                        while (j < length) {
                            if (!previousReparseStack[j].getReparseMacroName().equals(currentReparseStack[j].getReparseMacroName())) break;
                            lastCommonReparseElementIndex = j++;
                        }
                        if (lastCommonReparseElementIndex != -1) {
                            previousLine = previousReparseStack[lastCommonReparseElementIndex].getReparseMacroLine();
                            currentLine = currentReparseStack[lastCommonReparseElementIndex].getReparseMacroLine();
                        }
                    }
                }
                if (currentLine <= previousLine) {
                    return new AbstractDeclarationOrderCheck.HitElement(current, previous);
                }
                previous = current;
                ++i;
            }
        }
        return null;
    }
}

