/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractDeclarationOrderCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="20.1.15")
@CheckID(value="SVTB.7.1.1.1")
@CheckName(value="SVTB.7.1.1.1")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.REGISTRATION_MACRO, RuleLabel.STYLING, RuleLabel.VERIFICATION})
@CheckTitle(value="Field declaration order must match the order of field registration macros.")
@CheckDescription(value="Field declaration order must match the order of field registration macros.\nWhen field utils macros are used - the member order must match the macro call order.\nExample - correct:\nclass my_item extends uvm_sequence_item;\n  int foo;\n  int goo;\n\n  `uvm_object_utils_begin\n    `uvm_field_int(foo, UVM_ALL_ON)\n    `uvm_field_int(goo, UVM_ALL_ON)\n  `uvm_object_utils_end\nendclass: my_item\n\nincorrect:\nclass my_item extends uvm_sequence_item;\n  int boo;\n  int noo;\n\n  `uvm_object_utils_begin\n    `uvm_field_int(noo, UVM_ALL_ON)\n    `uvm_field_int(boo, UVM_ALL_ON) // Error - boo should come first\n  `uvm_object_utils_end\nendclass: my_item\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_1_1_1
extends AbstractDeclarationOrderCheck {
    final boolean isOVMLib;
    final Set<String> fieldRegistrationMacros;
    final Set<String> fieldEnumRegistrationMacros;

    public Check_SVTB_7_1_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        this.fieldRegistrationMacros = this.isOVMLib ? new HashSet<String>(Arrays.asList(XVMMacros.OVM_FIELD_MACROS)) : new HashSet<String>(Arrays.asList(XVMMacros.UVM_FIELD_MACROS));
        this.fieldEnumRegistrationMacros = this.isOVMLib ? new HashSet<String>(Arrays.asList("`ovm_field_enum", "`ovm_field_queue_enum", "`ovm_field_array_enum", "`ovm_field_sarray_enum", "`ovm_field_aa_int_enumkey")) : new HashSet<String>(Arrays.asList("`uvm_field_enum", "`uvm_field_queue_enum", "`uvm_field_array_enum", "`uvm_field_sarray_enum", "`uvm_field_aa_int_enumkey"));
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_FIELD_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_FIELD_MACROS));
        aRfProject.lintTrackMacrosByNames("class", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        RfClass xvmObjectClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object"), true);
        if (xvmObjectClass == null) {
            return;
        }
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            RfFileDef file;
            if (!LintUtils.isSubClassOf((RfClass)clazz, xvmObjectClass) || (file = clazz.getFile()) == null) continue;
            ParserPath parserPath = file.getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            List<FieldRegistrationInfo> macroCallParameters = this.getMacroCallParameters((RfClass)clazz);
            if (macroCallParameters == null || macroCallParameters.isEmpty()) continue;
            this.computeFieldsOffsets((RfClass)clazz, macroCallParameters);
            macroCallParameters.sort(new Comparator<FieldRegistrationInfo>(){

                @Override
                public int compare(FieldRegistrationInfo o1, FieldRegistrationInfo o2) {
                    return o1.getFieldDeclarationOffset() - o2.getFieldDeclarationOffset();
                }
            });
            String hitFile = LintUtils.getFileShortName(parserPath.path);
            FieldRegistrationInfo prev = null;
            FieldRegistrationInfo current = macroCallParameters.get(0);
            int i = 1;
            while (i < macroCallParameters.size()) {
                int currentRegistrationOffset;
                int prevRegistrationOffset;
                prev = current;
                current = macroCallParameters.get(i);
                MacroCallItem prevRegistrationMacroCall = prev.getMacroCall();
                MacroCallItem currentRegistrationMacroCall = current.getMacroCall();
                if (prevRegistrationMacroCall != null && currentRegistrationMacroCall != null && (prevRegistrationOffset = prevRegistrationMacroCall.getLineInfo().realOffset) > (currentRegistrationOffset = currentRegistrationMacroCall.getLineInfo().realOffset)) {
                    String hitMessage = "Field '" + current.getParameterName() + "' should be registered after field registration macro '" + prev.getParameterName() + "'" + " at line " + this.link(String.valueOf(Check_SVTB_7_1_1_1.getLine(prev.getMacroCall())) + " in file '" + hitFile + "'", parserPath.path, Check_SVTB_7_1_1_1.getLine(prev.getMacroCall())) + "!";
                    this.addHit(parserPath, Check_SVTB_7_1_1_1.getLine(current.getMacroCall()), hitMessage, Check_SVTB_7_1_1_1.getReparseInfo(current.getMacroCall()));
                }
                ++i;
            }
        }
    }

    private void computeFieldsOffsets(RfClass clazz, List<FieldRegistrationInfo> macroCallParameters) {
        List<RfField> fields = clazz.getLocalMembers(RfField.class);
        if (fields == null || fields.isEmpty()) {
            return;
        }
        if (macroCallParameters == null) {
            return;
        }
        for (RfField field : fields) {
            FieldRegistrationInfo macroCallInfo;
            RfDefElement fieldDef;
            if (field == null || !field.isField() || (fieldDef = field.getDeclaration()) == null || XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || (macroCallInfo = this.getMacroCallInfoByFieldName(macroCallParameters, field)) == null) continue;
            int fieldDeclarationOffset = fieldDef.getStartOffset();
            macroCallInfo.setFieldDeclarationOffset(fieldDeclarationOffset);
        }
    }

    private FieldRegistrationInfo getMacroCallInfoByFieldName(List<FieldRegistrationInfo> macroCallParameters, RfField field) {
        return macroCallParameters.stream().filter(macroCallInf -> field.getName().equals(macroCallInf.getParameterName())).findAny().orElse(null);
    }

    private List<FieldRegistrationInfo> getMacroCallParameters(RfClass clazz) {
        MacroCallInfo macroInfo = clazz.getMacroCallInfo();
        if (macroInfo == null) {
            return null;
        }
        List<MacroCallItem> allMacrosUsed = macroInfo.getItems();
        if (allMacrosUsed == null) {
            return null;
        }
        ArrayList<FieldRegistrationInfo> macroCallParameters = new ArrayList<FieldRegistrationInfo>();
        for (MacroCallItem macroCall : allMacrosUsed) {
            String[] parameters;
            if (!this.fieldRegistrationMacros.contains(macroCall.getName()) || (parameters = macroCall.getMacroParameters()).length == 0) continue;
            if (this.fieldEnumRegistrationMacros.contains(macroCall.getName())) {
                macroCallParameters.add(new FieldRegistrationInfo(parameters[1], macroCall));
                continue;
            }
            macroCallParameters.add(new FieldRegistrationInfo(parameters[0], macroCall));
        }
        return macroCallParameters;
    }

    private static class FieldRegistrationInfo {
        private String parameterName;
        private int fieldDeclarationOffset;
        private MacroCallItem macroCall;

        public FieldRegistrationInfo(String parameterName, MacroCallItem macroCall) {
            this.parameterName = parameterName;
            this.macroCall = macroCall;
            this.setFieldDeclarationOffset(-1);
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public int getFieldDeclarationOffset() {
            return this.fieldDeclarationOffset;
        }

        public void setFieldDeclarationOffset(int fieldDeclarationOffset) {
            this.fieldDeclarationOffset = fieldDeclarationOffset;
        }

        public MacroCallItem getMacroCall() {
            return this.macroCall;
        }
    }
}

