/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="16.1.9")
@CheckID(value="SVTB.7.1.2.2")
@CheckName(value="SVTB.7.1.2.2")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.CONSTRUCTOR, RuleLabel.METHOD, RuleLabel.FUNCTIONAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Class constructor must not call virtual functions")
@CheckDescription(value="The class constructor must not call, directly or indirectly, a virtual function belonging to the class being constructed (or to its parents).\nCalling a virtual function from a constructor can have unexpected results because the object on which it is being called is not yet constructed.\n\nExamples:\n\nclass base1;\n\tfunction new(int i); // not allowed\n\t\tvirtual_function();\n\tendfunction\n\n\tvirtual function virtual_function(); endfunction\nendclass\n\nclass base2;\n\tfunction new(); // allowed\n\t\tint x = 0;\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_SVTB_7_1_2_2
extends OVMComplianceCheck {
    public Check_SVTB_7_1_2_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement constructor : this.fOVMProject.getAllFunctionCallContainers()) {
            HashSet<RfFunction> visited;
            if (!(constructor instanceof RfFunction) || !((RfFunction)constructor).isConstructor()) continue;
            this.notifyCheckAlive();
            RfFileDef file = constructor.getFile();
            if ((file == null || !this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) && !this.hasIndirectCalledVirtualFunctions((RfFunction)constructor, constructor, "", 0, visited = new HashSet<RfFunction>())) continue;
        }
    }

    private boolean hasIndirectCalledVirtualFunctions(RfFunction function, RfNamedElement constructor, String functionCallStack, int callIndex, Set<RfFunction> visited) {
        List<RfFunctionCall> functionCalls = function.getFunctionCallsWithPrefix("", 2);
        for (RfFunctionCall functionCall : functionCalls) {
            RfFunction calledFunction = functionCall.getFunction();
            if (calledFunction == null || calledFunction.isConstructor()) continue;
            RfNamedElement enclosingScope = calledFunction.getEnclosingScope();
            RfNamedElement constructorEnclosingScope = constructor.getEnclosingScope();
            if (!(enclosingScope instanceof RfClass) || !(constructorEnclosingScope instanceof RfClass) || !enclosingScope.equals(constructorEnclosingScope)) continue;
            if (calledFunction.isVirtual()) {
                functionCallStack = String.valueOf(functionCallStack) + "\n" + callIndex + ": " + this.link(function) + "() - " + this.addLineFileInfo(functionCall, "calls " + functionCall.getFullName() + "() ");
                this.addHit(constructor, "In constructor '" + constructor.getFullName() + "()' the following virtual function is called: " + functionCall.getFullName() + "()! Call stack:" + functionCallStack);
                return true;
            }
            if (visited.contains(calledFunction)) continue;
            visited.add(calledFunction);
            if (!this.hasIndirectCalledVirtualFunctions(calledFunction, constructor, String.valueOf(functionCallStack) + "\n" + callIndex + ": " + this.link(function) + "() - " + this.addLineFileInfo(functionCall, ""), callIndex + 1, visited)) continue;
            return true;
        }
        return false;
    }
}

