/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.1.3")
@CheckName(value="SVTB.7.1.3")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.EXTERN, RuleLabel.FILE, RuleLabel.VERIFICATION})
@CheckTitle(value="Class declaration and implementation in a single file")
@CheckDescription(value="Declare the class and its implementation in a single file.\nHaving the implementation in a separate file from the declaration makes both reading and editing the class cumbersome.\n\nImplementation Notes:\nThis check verifies that extern constructors, functions, tasks and constraints are defined in the same file with their declaration.\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_1_3
extends OVMComplianceCheck {
    public Check_SVTB_7_1_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement eachNamedElement : this.fOVMProject.getAllNonXVMClasses()) {
            if (this.checkPreWaivers(eachNamedElement.getFile())) continue;
            RfClass eachClass = (RfClass)eachNamedElement;
            this.notifyCheckAlive();
            ArrayList<RfNamedElement> eachClassMethods = new ArrayList<RfNamedElement>();
            eachClassMethods.addAll(eachClass.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            eachClassMethods.addAll(eachClass.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            eachClassMethods.addAll(eachClass.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            this.checkNamedElements(eachClassMethods);
            ArrayList<RfNamedElement> eachClassConstraints = new ArrayList<RfNamedElement>();
            eachClassConstraints.addAll(eachClass.getConstraintsWithPrefix("", 2, 1));
            this.checkNamedElements(eachClassConstraints);
        }
    }

    private void checkNamedElements(List<RfNamedElement> aNamedElements) {
        for (RfNamedElement eachNamedElement : aNamedElements) {
            ArrayList<RfDefElement> defElements;
            if (eachNamedElement instanceof RfPredefinedFunction || (defElements = new ArrayList<RfDefElement>(eachNamedElement.getDeclarations())).isEmpty()) continue;
            this.checkDefElements(defElements);
        }
    }

    private void checkDefElements(List<RfDefElement> defs) {
        ParserPath declarationFileName = defs.get(0).getParserPath();
        if (declarationFileName == null) {
            return;
        }
        int i = 1;
        while (i < defs.size()) {
            ParserPath defFileName;
            RfDefElement def = defs.get(i);
            if (def != null && !declarationFileName.equals((Object)(defFileName = def.getParserPath()))) {
                this.addHit(defFileName, def.getStartLine(), "Implementation not in the same file as the declaration!", def.getReparseInfo());
            }
            ++i;
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

