/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.1.3.1")
@CheckName(value="SVTB.7.1.3.1")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.EXTERN, RuleLabel.VERIFICATION})
@CheckTitle(value="Illegal extern declaration")
@CheckDescription(value="Extern declarations are not allowed.\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_1_3_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="constructor, function, task, constraint", description="Comma separated list of constructor, function, task, constraint.", name="illegalExternConstructs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pIllegalExternConstructsValue;

    public Check_SVTB_7_1_3_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement eachNamedElement : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(eachNamedElement.getFile()) || eachNamedElement instanceof RfTypeAlias) continue;
            ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
            if (this.pIllegalExternConstructsValue.contains("constructor")) {
                result.addAll(eachNamedElement.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
                this.checkNoExtern(result, "constructor");
            }
            result = new ArrayList();
            if (this.pIllegalExternConstructsValue.contains("function")) {
                result.addAll(eachNamedElement.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
                this.checkNoExtern(result, "function");
            }
            result = new ArrayList();
            if (this.pIllegalExternConstructsValue.contains("task")) {
                result.addAll(eachNamedElement.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
                this.checkNoExtern(result, "task");
            }
            result = new ArrayList();
            if (!this.pIllegalExternConstructsValue.contains("constraint")) continue;
            result.addAll(eachNamedElement.getConstraintsWithPrefix("", 2, 1));
            this.checkNoExtern(result, "constraint");
        }
    }

    private void checkNoExtern(List<RfNamedElement> aNamedElements, String aInfo) {
        for (RfNamedElement eachNamedElement : aNamedElements) {
            if (eachNamedElement == null || !eachNamedElement.isExtern()) continue;
            this.addHit(eachNamedElement, "Illegal extern " + aInfo + " '" + eachNamedElement.getName() + "'!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

